
<?php $__env->startSection('pagetitle', 'Affiliates Manager'); ?>
<?php $__env->startSection('content'); ?>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <?php if(session('status')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('status')); ?>

                </div>
                <?php endif; ?>
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Affiliates Table</h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('addaff')); ?>" class="btn btn-success btn-sm"><i
                                    class="fa fa-user-plus fa-fw"></i> Add New </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>LP</th>
                                    <th>AFF ID</th>
                                    <th>Percent %</th>
                                    <th>Start After</th>
                                    <th>Current Sales</th>
                                    <th>Scrub Sales</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($el->id); ?></td>
                                    <td><?php echo e($el->parent->name); ?></td>
                                    <td><?php if($el->aff_id == null): ?> (default) <?php else: ?> <?php echo e($el->aff_id); ?> <?php endif; ?></td>
                                    <td><?php echo e($el->percent); ?> %</td>
                                    <td><?php echo e($el->start_after); ?> sales</td>
                                    <td><?php echo e($el->salesCounter); ?> sales</td>
                                    <td><?php echo e($el->scrubCounter); ?> sales</td>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="<?php echo e(route('editaff', $el->id)); ?>" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('deleteaff', $el->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger p-1">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orgdogmeatssv/public_html/ot1/konnektive/resources/views/AFF/index.blade.php ENDPATH**/ ?>