<?php $__env->startSection('pagetitle', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?php echo e($data['orders']); ?></h3>
                        <p>Orders Placed</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?php echo e($data['bounce']['percent']); ?><sup style="font-size: 20px">%</sup></h3>

                        <p>Conversion Rate <small class="d-inline-block">(<?php echo e($data['bounce']['partial']); ?> Total
                                Bounces)</small></p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?php echo e($data['revenue']); ?></h3>

                        <p>Total Revenue</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3><?php echo e($data['visits']); ?></h3>

                        <p>Unique Visitors</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-user-check"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex p-0">
                        <h3 class="card-title p-3">
                            <i class="fas fa-chart-pie mr-1"></i>
                            Conversion Chart
                        </h3>

                    </div><!-- /.card-header -->
                    <div class="card-body">
                        <div class="chart" id="sales-chart" style="position: relative; height: 300px;">
                            <canvas id="sales-chart-canvas" height="300" style="height: 300px;"></canvas>
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex p-0">
                        <h3 class="card-title p-3">
                            <i class="fas fa-chart-pie mr-1"></i>
                            Upsale Chart
                        </h3>
    
                    </div><!-- /.card-header -->
                    <div class="card-body">
                        <div class="chart" id="upsale-chart" style="position: relative; height: 300px;">
                            <canvas id="upsale-chart-canvas" height="300" style="height: 300px;"></canvas>
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
        </div>
    </div>
    </div>
    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/vendor/chart.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('/vendor/chart.min.js')); ?>"></script>
<script>
    var pieChartCanvas = $('#sales-chart-canvas').get(0).getContext('2d'),
        $a = <?php echo e($data['bounce']['partial']); ?>,
        $b = <?php echo e($data['bounce']['conversion']); ?>;

    var pieData = {
        labels: [
            'Partials',
            'Conversions',
        ],
        datasets: [{
            data: [$a, $b],
            backgroundColor: ['#f56954', '#00a65a', '#f39c12'],
        }]
    }
    var pieOptions = {
        legend: {
            display: true
        },
        maintainAspectRatio: false,
        responsive: true,
    }
    var pieChart = new Chart(pieChartCanvas, {
        type: 'pie',
        data: pieData,
        options: pieOptions
    });
    // upsale chart
    var pieChartCanvas = $('#upsale-chart-canvas').get(0).getContext('2d'),
        $a = <?php echo e($data['orders']); ?>,
        $b = <?php echo e($data['hasUpsale']); ?>,
        $c = <?php echo e($data['noUpsale']); ?>;
    var pieData = {
        labels: [
            'Total Orders',
            'With Upsales',
            'No Upsales'
        ],
        datasets: [{
            data: [$a, $b, $c],
            backgroundColor: ['#f56954', '#00a65a', '#f39c12'],
        }]
    }
    var pieOptions = {
        legend: {
            display: true
        },
        maintainAspectRatio: false,
        responsive: true,
    }
    var pieChart = new Chart(pieChartCanvas, {
        type: 'doughnut',
        data: pieData,
        options: pieOptions
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycialrxsd/public_html/ot1/konnektive/resources/views/home.blade.php ENDPATH**/ ?>