<?php $__env->startSection('pagetitle', 'Log Viewer'); ?>
<?php $__env->startSection('content'); ?>
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid logviewer">
                <div class="row">
                  <div class="col sidebar mb-3">
                    <h1><i class="fa fa-calendar" aria-hidden="true"></i> Laravel Log Viewer</h1>
                    <div class="list-group div-scroll">
                      <?php $__currentLoopData = $folders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="list-group-item">
                          <a href="?f=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($folder)); ?>">
                            <span class="fa fa-folder"></span> <?php echo e($folder); ?>

                          </a>
                          <?php if($current_folder == $folder): ?>
                            <div class="list-group folder">
                              <?php $__currentLoopData = $folder_files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="?l=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($file)); ?>&f=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($folder)); ?>"
                                  class="list-group-item <?php if($current_file == $file): ?> llv-active <?php endif; ?>">
                                  <?php echo e($file); ?>

                                </a>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                          <?php endif; ?>
                        </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="?l=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($file)); ?>"
                           class="list-group-item <?php if($current_file == $file): ?> llv-active <?php endif; ?>">
                          <?php echo e($file); ?>

                        </a>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                  </div>
                  <div class="col-10 table-container">
                    <?php if($logs === null): ?>
                      <div>
                        Log file >50M, please download it.
                      </div>
                    <?php else: ?>
                      <table id="table-log" class="table table-striped" data-ordering-index="<?php echo e($standardFormat ? 2 : 0); ?>">
                        <thead>
                        <tr>
                          <?php if($standardFormat): ?>
                            <th>Level</th>
                            <th>Context</th>
                            <th>Date</th>
                          <?php else: ?>
                            <th>Line number</th>
                          <?php endif; ?>
                          <th>Content</th>
                        </tr>
                        </thead>
                        <tbody>
              
                        <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr data-display="stack<?php echo e($key); ?>">
                            <?php if($standardFormat): ?>
                              <td class="nowrap text-<?php echo e($log['level_class']); ?>">
                                <span class="fa fa-<?php echo e($log['level_img']); ?>" aria-hidden="true"></span>&nbsp;&nbsp;<?php echo e($log['level']); ?>

                              </td>
                              <td class="text"><?php echo e($log['context']); ?></td>
                            <?php endif; ?>
                            <td class="date"><?php echo e($log['date']); ?></td>
                            <td class="text">
                              <?php if($log['stack']): ?>
                                <button type="button"
                                        class="float-right expand btn btn-outline-dark btn-sm mb-2 ml-2"
                                        data-display="stack<?php echo e($key); ?>">
                                  <span class="fa fa-search"></span>
                                </button>
                              <?php endif; ?>
                              <?php echo e($log['text']); ?>

                              <?php if(isset($log['in_file'])): ?>
                                <br/><?php echo e($log['in_file']); ?>

                              <?php endif; ?>
                              <?php if($log['stack']): ?>
                                <div class="stack" id="stack<?php echo e($key); ?>"
                                     style="display: none; white-space: pre-wrap;"><?php echo e(trim($log['stack'])); ?>

                                </div>
                              <?php endif; ?>
                            </td>
                          </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
                        </tbody>
                      </table>
                    <?php endif; ?>
                    <div class="p-3">
                      <?php if($current_file): ?>
                        <a href="?dl=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($current_file)); ?><?php echo e(($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : ''); ?>">
                          <span class="fa fa-download"></span> Download file
                        </a>
                        -
                        <a id="clean-log" href="?clean=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($current_file)); ?><?php echo e(($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : ''); ?>">
                          <span class="fa fa-sync"></span> Clean file
                        </a>
                        -
                        <a id="delete-log" href="?del=<?php echo e(\Illuminate\Support\Facades\Crypt::encrypt($current_file)); ?><?php echo e(($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : ''); ?>">
                          <span class="fa fa-trash"></span> Delete file
                        </a>
                        <?php if(count($files) > 1): ?>
                          -
                          <a id="delete-all-log" href="?delall=true<?php echo e(($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : ''); ?>">
                            <span class="fa fa-trash-alt"></span> Delete all files
                          </a>
                        <?php endif; ?>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
        </section>
        <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.css')); ?>">

<style>


    .logviewer h1 {
      font-size: 1.5em;
      margin-top: 0;
    }

    .logviewer #table-log {
        font-size: 0.85rem;
    }

    .logviewer .sidebar {
        font-size: 0.85rem;
        line-height: 1;
    }

    .logviewer .btn {
        font-size: 0.7rem;
    }

    .logviewer .stack {
      font-size: 0.85em;
    }

    .logviewer .date {
      min-width: 75px;
    }

    .logviewer .text {
      word-break: break-all;
    }

    .logviewer a.llv-active {
      z-index: 2;
      background-color: #f5f5f5;
      border-color: #777;
    }

    .logviewer .list-group-item {
      word-wrap: break-word;
    }

    .logviewer .folder {
      padding-top: 15px;
    }

    .logviewer .div-scroll {
      height: 80vh;
      overflow: hidden auto;
    }
    .logviewer .nowrap {
      white-space: nowrap;
    }

  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('/vendor/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    $(document).ready(function () {
      $('.table-container tr').on('click', function () {
        $('#' + $(this).data('display')).toggle();
      });
      $('#table-log').DataTable({
        "order": [$('#table-log').data('orderingIndex'), 'desc'],
        "stateSave": true,
        "stateSaveCallback": function (settings, data) {
          window.localStorage.setItem("datatable", JSON.stringify(data));
        },
        "stateLoadCallback": function (settings) {
          var data = JSON.parse(window.localStorage.getItem("datatable"));
          if (data) data.start = 0;
          return data;
        }
      });
      $('#delete-log, #clean-log, #delete-all-log').click(function () {
        return confirm('Are you sure?');
      });
    });
  </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dynamicketo/public_html/ot3/konnektive/resources/views/vendor/laravel-log-viewer/log.blade.php ENDPATH**/ ?>