<?php $__env->startSection('pagetitle', 'View Order'); ?>
<?php $__env->startPush('breadcrumbs'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('ordermanage',$order->parent->id)); ?>">Orders Manager</a></li>
<li class="breadcrumb-item active">View Order <?php echo e($order->orderId); ?></li>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex bg-primary align-items-center">
                <h3 class="card-title mb-0">View Order <?php echo e($order->orderId); ?></h3>
                <div class="card-tools">
                    <form action="<?php echo e(route('importOrder')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="token" value="<?php echo e($order->parent->token); ?>">
                        <input type="hidden" name="orderId" value="<?php echo e($order->orderId); ?>">
                        <button class="btn btn-sm btn-success btn-flat">Refresh Status</button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                
                <div class="row mb-3">
                    <div class="col-md-8">
                        <h4 class="mb-3">Client Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Name</th>
                                        <th>E-Mail</th>
                                        <th>Phone</th>
                                        <th>Address</th>
                                        <th>State</th>
                                        <th>City</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td><?php echo e($order->firstName); ?> <?php echo e($order->lastName); ?></td>
                                        <td><?php echo e($order->emailAddress); ?></td>
                                        <td><?php echo e($order->phoneNumber); ?></td>
                                        <td><?php echo e($order->address1); ?></td>
                                        <td><?php echo e($order->state); ?></td>
                                        <td><?php echo e($order->city); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <h4 class="mb-3">Payment Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Card Type</th>
                                        <th>Card Expiry</th>
                                        <th>Card Number</th>
                                        <th>Card Last 4</th>
                                        <th>Card CVV</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td><?php echo e($order->cardType); ?> </td>
                                        <td><?php echo e($order->cardExpiryDate); ?></td>
                                        <td><?php echo e($order->cardNumber); ?></td>
                                        <td><?php echo e($order->cardLast4); ?></td>
                                        <td><?php echo e($order->cardCVV); ?></td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <h4 class="mb-3">Order Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Campaign Id</th>
                                        <th>Order Id</th>
                                        <th>Order Status</th>
                                        <th>Affid</th>
                                        <th>Created At</th>
                                        <th>Updated At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td><?php echo e($order->campaignId); ?></td>
                                        <td><?php echo e($order->orderId); ?></td>
                                        <td><?php echo e($order->orderStatus); ?></td>
                                        <td><?php echo e($order->sourceId); ?></td>
                                        <td><?php echo e($order->dateCreated); ?></td>
                                        <td><?php echo e($order->updated_at); ?></td>
                                    </tr>
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycialrx/public_html/ot1/konnektive/resources/views/orders/show.blade.php ENDPATH**/ ?>