
<?php $__env->startSection('pagetitle', 'Orders Manager - '.$page->name); ?>
<?php $__env->startSection('content'); ?>
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <?php if(session('status')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('status')); ?>

                </div>
                <?php endif; ?>
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Orders Table</h3>
                        <div class="card-tools orderbtns">
                            <div class="btn-group">
                                <a class="btn btn-sm btn-info <?php echo e(request()->routeIs('ordermanageall',$page->id) ? 'active' : ''); ?>" href="<?php echo e(route('ordermanageall', $page->id)); ?>">All Orders</a>
                                <a class="btn btn-sm btn-warning <?php echo e(request()->routeIs('ordermanage',$page->id) ? 'active' : ''); ?>" href="<?php echo e(route('ordermanage',$page->id)); ?>" href="<?php echo e(route('ordermanage',$page->id)); ?>">Only Conversions</a>
                                
                            </div>

                        </div>
                    </div>
                    <div class="card-body">
                        <?php echo e($data->links()); ?>

                        <small>(showing only 500 entries per page to ease off serverload)</small>
                        <table class="table table-striped dataTable" id="table">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Campaign Id</th>
                                    <th>Order Id</th>
                                    <th>Customer Name</th>
                                    <th>Order Type</th>
                                    <th>Order Status</th>
                                    <th>Upsells Sold</th>
                                    <th>AffId</th>
                                    <th>Scrubbed Id</th>
                                    <th>Pixel Fired</th>
                                    <th>Created At</th>
                                    <?php if($page->type !='regular'): ?>
                                    <th>Rebill Due</th>
                                    <?php endif; ?>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($el->id); ?></td>
                                    <td><?php echo e($el->campaignId); ?></td>
                                    <td><?php echo e($el->orderId); ?></td>
                                    <td><?php echo e($el->firstName); ?> <?php echo e($el->lastName); ?></td>
                                    <td><?php echo e($el->orderType); ?></td>
                                    <td><?php echo e($el->orderStatus); ?></td>
                                    <td><?php echo e($el->upsells); ?></td>
                                    <td><?php if($el->sourceId): ?> <?php echo e($el->sourceId); ?> <?php else: ?> default <?php endif; ?></td>
                                    <td><?php if($el->scrubbedId): ?><span class="badge badge-danger text-center">scrubbed:<br>
                                            <?php echo e($el->scrubbedId); ?></span><?php else: ?> - <?php endif; ?></td>
                                    <td><span class="badge badge-<?php echo e($el->pixelFired === 'true' ? 'success' : 'danger'); ?>"><?php echo e($el->pixelFired); ?></span>
                                    </td>
                                    <td><?php echo e($el->created_at); ?></td>
                                    <?php if($el->parent->type !='regular'): ?>
                                    <?php
                                    $date = Carbon\Carbon::parse($el->created_at)->addDays($el->parent->morph_rebill_days);
                                    ?>
                                    <td><?php echo e($date->diffForHumans()); ?></td>
                                    <?php endif; ?>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="<?php echo e(route('editorder', $el->id)); ?>" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('orderDestroy')); ?>" id="ordr_<?php echo e($el->id); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="searchinput" class="searchTerm" value="<?php echo e(Cookie::get('searchTerm')); ?>">
                                                <input type="hidden" name="id" value="<?php echo e($el->id); ?>">
                                                <a href="#" data-toggle="modal" data-target="#deleteModal" onclick="setModal('#ordr_<?php echo e($el->id); ?>')" class="btn btn-sm btn-danger p-1 deletebtn">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <!-- ./col -->
        </div>
        <!-- /.row -->

    </div><!-- /.container-fluid -->
</section>
<div class="modal fade" id="deleteModal" data-source="" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content bg-danger">
            <div class="modal-header">
                <h4 class="modal-title">Are you Sure?</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>The record will be deleted and You cannot undo this!</p>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-outline-light" data-dismiss="modal">No</button>
                <button type="button" id="confirm" class="btn btn-outline-light">Yes, Delete</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('/vendor/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.js')); ?>"></script>

<script>
    $(function () {
        $('#table').DataTable({
            'paging': true,
            'lengthChange': false,
            'searching': true,
            'ordering': true,
            'autoWidth': false,
            'order':[[0, 'desc']]
        });
        $('#table_filter input').val('<?php echo e(Cookie::get('searchTerm')); ?>').keyup();
        $('#table_filter input').keyup(function(){
            $('.searchTerm').val($(this).val());
        });

        $('#confirm').click(function(){
            $tar = $('#deleteModal').data('source');
            // console.log($tar);
            $($tar).submit();
        });

    })
    function setModal($id){
        $('#deleteModal').attr('data-source', $id);
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycialrxnew/public_html/ot1/konnektive/resources/views/orders/index.blade.php ENDPATH**/ ?>