
<?php $__env->startSection('pagetitle', 'LPs Manager'); ?>
<?php $__env->startSection('content'); ?>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <?php if(session('status')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('status')); ?>

                </div>
                <?php endif; ?>
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">LPs Table</h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('addlp')); ?>" class="btn btn-success btn-sm"><i class="fa fa-user-plus fa-fw"></i> Add New </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Name</th>
                                    <th>Identifier</th>
                                    <th>Url</th>
                                    <th>Type</th>
                                    <th>Orders</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($el->id); ?></td>
                                    <td><?php echo e($el->name); ?></td>
                                    <td><?php echo e($el->token); ?></td>
                                    <td><a href="<?php echo e($el->url); ?>" target="_blank"><?php echo e($el->url); ?></a></td>
                                    <td><?php echo e($el->type); ?></td>
                                    <td><?php echo e($el->orders->count()); ?></td>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="<?php echo e(route('editlp', $el->id)); ?>" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('lpDestroy',$el->id)); ?>" id="ordr_<?php echo e($el->id); ?>" method="GET">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($el->id); ?>">
                                                <a href="#" data-toggle="modal" data-target="#deleteModal" onclick="setModal('#ordr_<?php echo e($el->id); ?>')" class="btn btn-sm btn-danger p-1 deletebtn">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<div class="modal fade" id="deleteModal" data-source="" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content bg-danger">
            <div class="modal-header">
                <h4 class="modal-title">Are you Sure?</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>The record will be deleted and You cannot undo this!</p>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-outline-light" data-dismiss="modal">No</button>
                <button type="button" id="confirm" class="btn btn-outline-light">Yes, Delete</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script>
    $(function () {
         $('#confirm').click(function(){
            $tar = $('#deleteModal').data('source');
            // console.log($tar);
            $($tar).submit();
        });

    })
    function setModal($id){
        $('#deleteModal').attr('data-source', $id);
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orgdogmeatssv/public_html/ot1/konnektive/resources/views/LPS/index.blade.php ENDPATH**/ ?>