<?php $__env->startSection('pagetitle', 'Import Declined Orders'); ?>
<?php $__env->startSection('content'); ?>
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Import and retry failed orders</h3>
                        <div class="card-tools">
                            <a class="btn btn-sm btn-success" href="<?php echo e(route('importOrdersCustom')); ?>">Import Custom Orders</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p>This tool will import orders from a csv exported by konnektive crm</p>
                                <p>Please only input csv files that have a declined/hard declined state</p>
                                <p>The function can create <strong>a new order</strong> with the client information of a
                                    matching orderid from the database.</p>
                                <p>If the csv contains order ids that have no match in our database they will be ignored
                                </p>

                            </div>
                            <div class="col-md-6">
                                <?php if(count($orders)>0): ?>
                                <p>You already imported declined orders. To import new ones please first handle the ones
                                    below or delete them all <a href="<?php echo e(route('clearImport')); ?>">here</a></p>
                                <?php endif; ?>

                                <form action="<?php echo e(route('handleImport')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="file">
                                                <label class="custom-file-label" for="exampleInputFile">Choose
                                                    file</label>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-success">upload</button>
                                </form>
                            </div>
                        </div>
                        
                        <div class="row">
                            <?php if(session()->get( 'notFound' )): ?>
                            <div class="col-md-12">
                                <?php if(count(session()->get( 'notFound' ))>0): ?>
                                <p>Found <?php echo e(count(session()->get( 'notFound' ))); ?>, orders with no matching db record:<br>
                                    <?php $__currentLoopData = session()->get( 'notFound' ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><span class="badge badge-info"><?php echo e($el); ?></span>, <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </p>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <table class="table table-striped dataTable" id="table">
                            <thead>
                                <tr>
                                    <th>Order Id</th>
                                    <th>Customer Id</th>
                                    <th>Cycle</th>
                                    <th>Created At</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($el->orderId); ?></td>
                                    <td><?php echo e($el->customerId); ?></td>
                                    <td><?php echo e($el->cycle); ?></td>
                                    <td><?php echo e($el->date); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-success" data-toggle="modal" data-target="#retry-<?php echo e($el->id); ?>">retry</button>
                                        <div class="modal fade" id="retry-<?php echo e($el->id); ?>" data-source="" style="display: none;">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Retry Order id <?php echo e($el->orderId); ?>

                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form id="retry_form_<?php echo e($el->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <input type="hidden" name="id" value="<?php echo e($el->id); ?>">
                                                            <div class="form-group">
                                                                <label for="customerId">Customer Id</label>
                                                                <input type="text" name="customerId" value="<?php echo e($el->customerId); ?>" class="form-control">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="campaignId">Campaign Id</label>
                                                                <input type="text" name="campaignId" value="147" class="form-control">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for="product1_id">Step 1</label>
                                                                <input type="text" name="product1_id" value="<?php echo e($el->cycle == 2 ? '642' : '657'); ?>" class="form-control">
                                                            </div>
                                                            <?php if($el->order->upsells >= 1): ?>
                                                            <div class="form-group">
                                                                <label for="product2_id">Step 2</label>
                                                                <input type="text" name="product2_id" value="<?php echo e($el->cycle == 2 ? '643' : '658'); ?>" class="form-control">
                                                            </div>
                                                            <?php endif; ?>

                                                            <p class="text-muted">By submitting this form a new order
                                                                will be created for the customer with the above ID with
                                                                all the information already on file. The customer will
                                                                be billed!</p>
                                                        </div>
                                                        <div class="modal-footer justify-content-between">
                                                            <button type="button" class="btn btn-success btn-block btn-flat retry_btn" data-form="#retry_form_<?php echo e($el->id); ?>">Retry</button>
                                                        </div>
                                                    </form>
                                                </div>
                                                <!-- /.modal-content -->
                                            </div>
                                            <!-- /.modal-dialog -->
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <!-- ./col -->
        </div>
        <!-- /.row -->

    </div><!-- /.container-fluid -->
    
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('/vendor/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('/vendor/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>

<script>
    $(function(){

    $('.upload').click(function(){
        $(this).addClass('disabled').html('Loading');
    });
    $('.retry_btn').click(function(){
        $(this).addClass('disabled').html('Loading');
        $form = $($(this).data('form'));
        if($form){
            $data =$form.serialize();
            // console.log($data);
            // return;
            $.ajax({
                url: "<?php echo e(route('retryOrder')); ?>",
                type: "POST",
                data: $data,
                success($response) {
                    $response = JSON.parse($response);
                    if($response.result == 'SUCCESS'){
                        alert($response.result);
                        window.location.reload();
                    }else{
                        alert($response.message);
                        window.location.reload();

                    }

                }
            });
        }
    })
    $('#table').DataTable({
        'paging': true,
        'lengthChange': false,
        'searching': true,
        'ordering': true,
        'autoWidth': false,
        'order':[[3, 'desc']]
    });
     
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycialrx/public_html/ot1/konnektive/resources/views/orders/import.blade.php ENDPATH**/ ?>