<?php $__env->startSection('pagetitle', 'View Order'); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex bg-primary align-items-center">
                <h3 class="card-title mb-0">View Order <?php echo e($order->orderId); ?></h3>
                <div class="card-tools">
                    <form action="<?php echo e(route('importOrder')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="token" value="<?php echo e($order->parent->token); ?>">
                        <input type="hidden" name="orderId" value="<?php echo e($order->orderId); ?>">
                        <button class="btn btn-sm btn-success btn-flat">Refresh Status</button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                
                <div class="row mb-3">
                    <div class="col-md-8">
                        <h4 class="mb-3">Client Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Name</th>
                                        <th>E-Mail</th>
                                        <th>Phone</th>
                                        <th>Address</th>
                                        <th>State</th>
                                        <th>City</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td><?php echo e($order->firstName); ?> <?php echo e($order->lastName); ?></td>
                                        <td><?php echo e($order->emailAddress); ?></td>
                                        <td><?php echo e($order->phoneNumber); ?></td>
                                        <td><?php echo e($order->address1); ?></td>
                                        <td><?php echo e($order->state); ?></td>
                                        <td><?php echo e($order->city); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4">
                            <h4 class="mb-3">Payment Information</h4>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                    <thead>
                                        <tr role="row">
                                            <th>Card Type</th>
                                            <th>Card Expiry</th>
                                            <th>Card Number</th>
                                            <th>Card Last 4</th>
                                            <th>Card CVV</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr role="row">
                                            <td><?php echo e($order->cardType); ?> </td>
                                            <td><?php echo e($order->cardExpiryDate); ?></td>
                                            <td><?php echo e($order->cardNumber); ?></td>
                                            <td><?php echo e($order->cardLast4); ?></td>
                                            <td><?php echo e($order->cardCVV); ?></td>
                                   
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <div class="col-md-12">
                        <h4 class="mb-3">Order Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Campaign Id</th>
                                        <th>Order Id</th>
                                        <th>Order Status</th>
                                        <th>Affid</th>
                                        <th>Created At</th>
                                        <th>Updated At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td><?php echo e($order->campaignId); ?></td>
                                        <td><?php echo e($order->orderId); ?></td>
                                        <td><?php echo e($order->orderStatus); ?></td>
                                        <td><?php echo e($order->sourceId); ?></td>
                                        <td><?php echo e($order->dateCreated); ?></td>
                                        <td><?php echo e($order->updated_at); ?></td>
                                    </tr>
                                </tbody>

                            </table>
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <?php if(session()->has('cardUpdated')): ?>
                        <div class="alert alert-info">
                            <?php echo e(session('cardUpdated')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(session()->has('rebilled')): ?>
                        <div class="alert alert-info">
                            <?php echo e(session('rebilled')); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Get Client Information & Rebill Order</h4>
                                <div class="card-tools">
                                    <form action="<?php echo e(route('getClient')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="token" value="<?php echo e($order->parent->token); ?>">
                                        <input type="hidden" name="customerId" value="<?php echo e($order->customerId); ?>">
                                        <button type="submit" class="btn btn-success btn-flat btn-sm">Change CC
                                            info</button>
                                    </form>

                                </div>
                            </div>
                            <?php if(session()->has('client')): ?>
                            <?php $el = json_decode(session('client'))?>
                            <div class="card-body">
                         
                                <h5>Current Card(s)</h5>
                                <table class="table">
                                    <tr>
                                        <th>paySourceId</th>
                                        <th>Primary</th>
                                        <th>Type</th>
                                        <th>Last 4 Digits</th>
                                        <th>Expiry</th>
                                    </tr>
                                    <?php $__currentLoopData = $el->message->data[0]->paySources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($card->paySourceId); ?></td>
                                        <td><?php echo e($card->IsPrimary); ?></td>
                                        <td><?php echo e($card->paySourceType); ?> / <?php echo e($card->cardType); ?></td>
                                        <td><?php echo e($card->cardLast4); ?></td>
                                        <td><?php echo e($card->cardExpiryDate); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                            <?php endif; ?>
                            <div class="card-footer">
                                <form action="<?php echo e(route('rerunDeclined')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="token" value="<?php echo e($order->parent->token); ?>">
                                    <input type="hidden" name="orderId" value="<?php echo e($order->orderId); ?>">
                                    <div class="form-group">
                                        <label for="forceBillerId">Force new Biller Id</label>
                                        <input class="form-control" type="text" name="forceBillerId" value="">
                                    </div>
                                    <button type="submit" class="btn btn-success btn-flat btn-sm">Rebill Order</button>
                                </form>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php if(session()->has('client')): ?>
                        <div class="card">
                            <form action="<?php echo e(route('updateCard')); ?>" method="POST">
                                <input type="hidden" name="token" value="<?php echo e($order->parent->token); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="card-header">
                                    <h4>Change Credit Card Info</h4>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="paySourceId">Payment Source Id</label>
                                        <input class="form-control" type="tel" name="paySourceId" value="<?php echo e($el->message->data[0]->paySources[0]->paySourceId); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="cardType">Credit Card Type</label>
                                        <select class="form-control" name="cardType">
                                            <option value="">Select Card Type</option>
                                            <option value="VISA">Visa</option>
                                            <option value="MASTERCARD">Mastercard</option>
                                            <option value="AMEX">Amex</option>
                                            <option value="DISCOVER">Discover</option> 
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="cardNumber">Credit Card Number</label>
                                        <input maxlength="16" class="form-control" type="tel" name="cardNumber"
                                            value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="cardMonth">Expiry Month</label>
                                        <input maxlength="2" class="form-control" type="tel" name="cardMonth" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="cardYear">Expiry Year</label>
                                        <input maxlength="4" class="form-control" type="tel" name="cardYear" value="">
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-success btn-flat btn-sm">Save Card</button>

                                </div>
                            </form>
                        </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dynamicketo/public_html/ot3/konnektive/resources/views/orders/show.blade.php ENDPATH**/ ?>