<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Auth::routes();

Route::get('/', 'HomeController@index')->name('home');
Route::get('/dashboard/{id}', 'HomeController@index')->name('dashboard');
Route::get('/profile', 'HomeController@profile')->name('profile');
Route::post('/profile', 'UserController@update')->name('profile');
Route::get('/file-manager', 'HomeController@filemanage')->name('filemanage');

Route::get('/lps/index', 'HomeController@lpmanage')->name('lps'); 
Route::get('/lps/create', 'HomeController@addlp')->name('addlp'); 
Route::post('/lps/create', 'LPsController@storeData')->name('storelp'); 
Route::get('/lps/show/{id}', 'LPsController@editlp')->name('editlp'); 
Route::post('/lps/update/{id}', 'LPsController@updateData')->name('updatelp'); 
Route::get('/lps/destroy/{id}', 'LPsController@destroy')->name('lpDestroy'); 

Route::get('/order/index/{id}', 'HomeController@ordermanage')->name('ordermanage'); 
Route::get('/order/index/all/{id}', 'HomeController@ordermanageall')->name('ordermanageall'); 
Route::get('/order/index/declined/{id}', 'HomeController@ordermanagedeclined')->name('ordermanagedeclined'); 
Route::get('/order/show/{id}', 'OrdersController@editorder')->name('editorder'); 
Route::get('/order/import', 'HomeController@importOrders')->name('importOrders'); 
Route::post('/order/import/csv', 'HomeController@handleImport')->name('handleImport'); 
Route::get('/order/import/clear', 'HomeController@clearImport')->name('clearImport'); 
Route::post('/order/import/retry', 'HomeController@retryOrder')->name('retryOrder'); 
Route::post('/order/import/retryall', 'HomeController@batchRetryOrder')->name('batchRetryOrder'); 

Route::get('/order/import/custom', 'HomeController@importCustomOrders')->name('importOrdersCustom'); 
Route::post('/order/import/custom/csv', 'HomeController@handleImportCustom')->name('handleImportCustom'); 
Route::post('/order/import/retry/custom', 'HomeController@retryOrderCustom')->name('retryOrderCustom'); 


// Route::post('/order/rebill', 'API\RequestsController@rebillOrder')->name('rebillOrder'); 
Route::post('/order/getclient/', 'OrdersController@getClient')->name('getClient'); 
Route::post('/order/updateCard/', 'OrdersController@updateCard')->name('updateCard'); 
Route::post('/order/rebill/', 'OrdersController@rerunDeclined')->name('rerunDeclined'); 
Route::post('/order/refresh/', 'OrdersController@importOrder')->name('importOrder'); 
Route::post('/order/destroy/', 'OrdersController@destroy')->name('orderDestroy'); 

Route::get('/affs/index', 'HomeController@affmanage')->name('affmanage'); 
Route::get('/affs/create', 'HomeController@addAff')->name('addaff'); 
Route::post('/affs/create', 'AffiliateController@storeData')->name('storeaff'); 
Route::get('/affs/show/{id}', 'AffiliateController@editaff')->name('editaff'); 
Route::post('/affs/update/{id}', 'AffiliateController@updateData')->name('updateaff'); 
Route::post('/affs/delete/{id}', 'AffiliateController@deleteAff')->name('deleteaff'); 
Route::group(['middleware'=>'auth'], function(){
    Route::get('logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index')->name('logs');
});
