<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['hasToken','cors'])->group(function () {
    Route::get('feed/{id}','API\RequestsController@feedLp');
    Route::post('post/lead','API\RequestsController@getProspect');
    Route::post('post/new_order','API\RequestsController@newOrderWithProspect');
    Route::post('post/new_order_cc','API\RequestsController@newOrderWithCc');
    Route::post('post/upsell','API\RequestsController@newUpsell');
    Route::post('order/pixel','API\RequestsController@togglePixelChange');
});
