@extends('layouts.app')
@section('pagetitle', 'View Order')
@push('breadcrumbs')
<li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
<li class="breadcrumb-item"><a href="{{route('ordermanage',$order->parent->id)}}">Orders Manager</a></li>
<li class="breadcrumb-item active">View Order {{$order->orderId}}</li>
@endpush
@section('content')
<div class="container-fluid">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex bg-primary align-items-center">
                <h3 class="card-title mb-0">View Order {{$order->orderId}}</h3>
                <div class="card-tools">
                    <form action="{{route('importOrder')}}" method="POST">
                        @csrf
                        <input type="hidden" name="token" value="{{$order->parent->token}}">
                        <input type="hidden" name="orderId" value="{{$order->orderId}}">
                        <button class="btn btn-sm btn-success btn-flat">Refresh Status</button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                {{-- <form role="form" method="POST" action="{{ route('updatelp', $order->id) }}">
                @csrf --}}
                <div class="row mb-3">
                    <div class="col-md-8">
                        <h4 class="mb-3">Client Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Name</th>
                                        <th>E-Mail</th>
                                        <th>Phone</th>
                                        <th>Address</th>
                                        <th>State</th>
                                        <th>City</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td>{{$order->firstName}} {{$order->lastName}}</td>
                                        <td>{{$order->emailAddress}}</td>
                                        <td>{{$order->phoneNumber}}</td>
                                        <td>{{$order->address1}}</td>
                                        <td>{{$order->state}}</td>
                                        <td>{{$order->city}}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <h4 class="mb-3">Payment Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Card Type</th>
                                        <th>Card Expiry</th>
                                        <th>Card Number</th>
                                        <th>Card Last 4</th>
                                        <th>Card CVV</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td>{{$order->cardType}} </td>
                                        <td>{{$order->cardExpiryDate}}</td>
                                        <td>{{$order->cardNumber}}</td>
                                        <td>{{$order->cardLast4}}</td>
                                        <td>{{$order->cardCVV}}</td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <h4 class="mb-3">Order Information</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" role="grid" aria-describedby="table">
                                <thead>
                                    <tr role="row">
                                        <th>Campaign Id</th>
                                        <th>Order Id</th>
                                        <th>Order Status</th>
                                        <th>Affid</th>
                                        <th>Created At</th>
                                        <th>Updated At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr role="row">
                                        <td>{{$order->campaignId}}</td>
                                        <td>{{$order->orderId}}</td>
                                        <td>{{$order->orderStatus}}</td>
                                        <td>{{$order->sourceId}}</td>
                                        <td>{{$order->dateCreated}}</td>
                                        <td>{{$order->updated_at}}</td>
                                    </tr>
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('styles')
@stop
@section('scripts')
@stop