@extends('layouts.app')
@section('pagetitle', 'Orders Manager - '.$page->name)
@section('content')
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                @if(session('status'))
                <div class="alert alert-success" role="alert">
                    {{ session('status') }}
                </div>
                @endif
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Orders Table</h3>
                        <div class="card-tools orderbtns">
                            <div class="btn-group">
                                <a class="btn btn-sm btn-info {{ request()->routeIs('ordermanageall',$page->id) ? 'active' : '' }}" href="{{route('ordermanageall', $page->id)}}">All Orders</a>
                                <a class="btn btn-sm btn-warning {{ request()->routeIs('ordermanage',$page->id) ? 'active' : '' }}" href="{{route('ordermanage',$page->id)}}" href="{{route('ordermanage',$page->id)}}">Only Conversions</a>
                                {{-- <a href="{{route('importOrders')}}" class="btn btn-sm btn-success"><i class="fa fa-upload"></i> Import orders .csv</a> --}}
                            </div>

                        </div>
                    </div>
                    <div class="card-body">
                        {{ $data->links() }}
                        <small>(showing only 500 entries per page to ease off serverload)</small>
                        <table class="table table-striped dataTable" id="table">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Campaign Id</th>
                                    <th>Order Id</th>
                                    <th>Customer Name</th>
                                    <th>Order Type</th>
                                    <th>Order Status</th>
                                    <th>Upsells Sold</th>
                                    <th>AffId</th>
                                    <th>Scrubbed Id</th>
                                    <th>Pixel Fired</th>
                                    <th>Created At</th>
                                    @if($page->type !='regular')
                                    <th>Rebill Due</th>
                                    @endif
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $el)
                                <tr>
                                    <td>{{$el->id}}</td>
                                    <td>{{$el->campaignId}}</td>
                                    <td>{{$el->orderId}}</td>
                                    <td>{{$el->firstName}} {{$el->lastName}}</td>
                                    <td>{{$el->orderType}}</td>
                                    <td>{{$el->orderStatus}}</td>
                                    <td>{{$el->upsells}}</td>
                                    <td>@if($el->sourceId) {{$el->sourceId}} @else default @endif</td>
                                    <td>@if ($el->scrubbedId)<span class="badge badge-danger text-center">scrubbed:<br>
                                            {{$el->scrubbedId}}</span>@else - @endif</td>
                                    <td><span class="badge badge-{{ $el->pixelFired === 'true' ? 'success' : 'danger' }}">{{$el->pixelFired}}</span>
                                    </td>
                                    <td>{{$el->created_at}}</td>
                                    @if($el->parent->type !='regular')
                                    @php
                                    $date = Carbon\Carbon::parse($el->created_at)->addDays($el->parent->morph_rebill_days);
                                    @endphp
                                    <td>{{$date->diffForHumans()}}</td>
                                    @endif
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="{{ route('editorder', $el->id) }}" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{route('orderDestroy')}}" id="ordr_{{$el->id}}" method="POST">
                                                @csrf
                                                <input type="hidden" name="searchinput" class="searchTerm" value="{{Cookie::get('searchTerm')}}">
                                                <input type="hidden" name="id" value="{{$el->id}}">
                                                <a href="#" data-toggle="modal" data-target="#deleteModal" onclick="setModal('#ordr_{{$el->id}}')" class="btn btn-sm btn-danger p-1 deletebtn">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <!-- ./col -->
        </div>
        <!-- /.row -->

    </div><!-- /.container-fluid -->
</section>
<div class="modal fade" id="deleteModal" data-source="" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content bg-danger">
            <div class="modal-header">
                <h4 class="modal-title">Are you Sure?</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>The record will be deleted and You cannot undo this!</p>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-outline-light" data-dismiss="modal">No</button>
                <button type="button" id="confirm" class="btn btn-outline-light">Yes, Delete</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@endsection
@section('styles')
<link rel="stylesheet" href="{{asset('/vendor/datatables/dataTables.bootstrap4.min.css')}}">
@stop
@section('scripts')
<script src="{{asset('/vendor/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('/vendor/datatables/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(function () {
        $('#table').DataTable({
            'paging': true,
            'lengthChange': false,
            'searching': true,
            'ordering': true,
            'autoWidth': false,
            'order':[[0, 'desc']]
        });
        $('#table_filter input').val('{{Cookie::get('searchTerm')}}').keyup();
        $('#table_filter input').keyup(function(){
            $('.searchTerm').val($(this).val());
        });

        $('#confirm').click(function(){
            $tar = $('#deleteModal').data('source');
            // console.log($tar);
            $($tar).submit();
        });

    })
    function setModal($id){
        $('#deleteModal').attr('data-source', $id);
    }
</script>
@stop