@extends('layouts.app')
@section('pagetitle', 'Import Declined Orders')
@section('content')
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Import and retry failed orders</h3>
                        <div class="card-tools">
                            <a class="btn btn-sm btn-success" href="{{route('importOrdersCustom')}}">Import Custom Orders</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p>This tool will import orders from a csv exported by konnektive crm</p>
                                <p>Please only input csv files that have a declined/hard declined state</p>
                                <p>The function can create <strong>a new order</strong> with the client information of a
                                    matching orderid from the database.</p>
                                <p>If the csv contains order ids that have no match in our database they will be ignored
                                </p>

                            </div>
                            <div class="col-md-6">
                                @if(count($orders)>0)
                                <p>You already imported declined orders. To import new ones please first handle the ones
                                    below or delete them all <a href="{{route('clearImport')}}">here</a></p>
                                @endif

                                <form action="{{route('handleImport')}}" method="POST" enctype="multipart/form-data">
                                    @csrf

                                    <div class="form-group">
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="file">
                                                <label class="custom-file-label" for="exampleInputFile">Choose
                                                    file</label>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-success">upload</button>
                                </form>
                            </div>
                        </div>
                        {{-- {{ $data->links() }}
                        <small>(showing only 500 entries per page to ease off serverload)</small> --}}
                        <div class="row">
                            @if(session()->get( 'notFound' ))
                            <div class="col-md-12">
                                @if(count(session()->get( 'notFound' ))>0)
                                <p>Found {{count(session()->get( 'notFound' ))}}, orders with no matching db record:<br>
                                    @foreach(session()->get( 'notFound' ) as $el)<span class="badge badge-info">{{$el}}</span>, @endforeach
                                </p>
                                @endif
                            </div>
                            @endif
                        </div>
                        <table class="table table-striped dataTable" id="table">
                            <thead>
                                <tr>
                                    <th>Order Id</th>
                                    <th>Customer Id</th>
                                    <th>Cycle</th>
                                    <th>Created At</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($orders as $el)
                                <tr>
                                    <td>{{$el->orderId}}</td>
                                    <td>{{$el->customerId}}</td>
                                    <td>{{$el->cycle}}</td>
                                    <td>{{$el->date}}</td>
                                    <td>
                                        <button class="btn btn-sm btn-success" data-toggle="modal" data-target="#retry-{{$el->id}}">retry</button>
                                        <div class="modal fade" id="retry-{{$el->id}}" data-source="" style="display: none;">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Retry Order id {{$el->orderId}}
                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form id="retry_form_{{$el->id}}">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <input type="hidden" name="id" value="{{$el->id}}">
                                                            <div class="form-group">
                                                                <label for="customerId">Customer Id</label>
                                                                <input type="text" name="customerId" value="{{$el->customerId}}" class="form-control">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="campaignId">Campaign Id</label>
                                                                <input type="text" name="campaignId" value="147" class="form-control">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for="product1_id">Step 1</label>
                                                                <input type="text" name="product1_id" value="{{$el->cycle == 2 ? '642' : '657'}}" class="form-control">
                                                            </div>
                                                            @if($el->order->upsells >= 1)
                                                            <div class="form-group">
                                                                <label for="product2_id">Step 2</label>
                                                                <input type="text" name="product2_id" value="{{$el->cycle == 2 ? '643' : '658'}}" class="form-control">
                                                            </div>
                                                            @endif

                                                            <p class="text-muted">By submitting this form a new order
                                                                will be created for the customer with the above ID with
                                                                all the information already on file. The customer will
                                                                be billed!</p>
                                                        </div>
                                                        <div class="modal-footer justify-content-between">
                                                            <button type="button" class="btn btn-success btn-block btn-flat retry_btn" data-form="#retry_form_{{$el->id}}">Retry</button>
                                                        </div>
                                                    </form>
                                                </div>
                                                <!-- /.modal-content -->
                                            </div>
                                            <!-- /.modal-dialog -->
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {{-- <button class="btn btn-flat btn-success btn-block" data-toggle="modal"
                            data-target="#retryall">Batch Retry
                            all Orders</button> --}}
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <!-- ./col -->
        </div>
        <!-- /.row -->

    </div><!-- /.container-fluid -->
    {{-- <div class="modal fade" id="retryall" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Retry all Orders</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form class="retry_form_all" method="POST" action="{{route('batchRetryOrder')}}">
    @csrf
    <div class="modal-body">
        <div class="form-group">
            <label for="campaignId">Campaign Id</label>
            <input type="text" name="campaignId" value="147" class="form-control">
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="product1_id_c2">Step 1 for cycle 2</label>
                    <input type="text" name="product1_id_c2" value="642" class="form-control">
                </div>
                <div class="form-group">
                    <label for="product2_id_c2">Step 2 for cycle 2</label>
                    <input type="text" name="product2_id_c2" value="643" class="form-control">
                </div>

            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="product1_id_c3">Step 1 for cycle 3+</label>
                    <input type="text" name="product1_id_c3" value="657" class="form-control">
                </div>
                <div class="form-group">
                    <label for="product2_id_c3">Step 2 for cycle 3+</label>
                    <input type="text" name="product2_id_c3" value="658" class="form-control">
                </div>

            </div>
        </div>

        <p class="text-muted">By submitting this form a new order
            will be created for the customers associated to all the orders with
            all the information already on file. The customers will
            be billed!</p>
        <p class="text-muted">The upsells will be added if the order had any and ignored if order didnt
            have upsells.</p>
    </div>
    <div class="modal-footer justify-content-between">
        <button type="submit" class="btn btn-success btn-block btn-flat retry_btn">Retry</button>
    </div>
    </form>
    </div>
    <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
    </div> --}}
</section>
@endsection
@section('styles')
<link rel="stylesheet" href="{{asset('/vendor/datatables/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css" />
@stop
@section('scripts')
<script src="{{asset('/vendor/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('/vendor/datatables/dataTables.bootstrap4.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>

<script>
    $(function(){

    $('.upload').click(function(){
        $(this).addClass('disabled').html('Loading');
    });
    $('.retry_btn').click(function(){
        $(this).addClass('disabled').html('Loading');
        $form = $($(this).data('form'));
        if($form){
            $data =$form.serialize();
            // console.log($data);
            // return;
            $.ajax({
                url: "{{route('retryOrder')}}",
                type: "POST",
                data: $data,
                success($response) {
                    $response = JSON.parse($response);
                    if($response.result == 'SUCCESS'){
                        alert($response.result);
                        window.location.reload();
                    }else{
                        alert($response.message);
                        window.location.reload();

                    }

                }
            });
        }
    })
    $('#table').DataTable({
        'paging': true,
        'lengthChange': false,
        'searching': true,
        'ordering': true,
        'autoWidth': false,
        'order':[[3, 'desc']]
    });
     
    });
</script>
@stop