@extends('layouts.app')
@section('pagetitle', 'Edit LP')
@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- general form elements -->
                    <div class="card card-primary">
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form role="form" method="POST" action="{{ route('updatelp', $lp->id) }}">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4 class="mb-3">Site Settings</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="name">Name</label>
                                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" placeholder="Enter LP Name" value="{{$lp->name}}">
                                                    @error('name')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="token">Identifier Token</label>
                                                    <input type="text" class="form-control @error('token') is-invalid @enderror" id="token" name="token" placeholder="Enter LP Identifier" value="{{$lp->token}}">
                                                    @error('token')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="api_user">API Username</label>
                                                    <input type="text" class="form-control @error('api_user') is-invalid @enderror" value="{{$lp->api_user}}" id="api_user" name="api_user" placeholder="Enter API User">
                                                    @error('api_user')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="api_password">API Password</label>
                                                    <input type="text" class="form-control @error('api_password') is-invalid @enderror" value="{{$lp->api_password}}" id="api_password" name="api_password" placeholder="Enter API Password">
                                                    @error('api_password')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="type">LP Type</label>
                                                    <select name="type" class="form-control @error('type') is-invalid @enderror">
                                                        <option @if($lp->type ==='regular') selected @endif value="regular">Regular</option>
                                                        <option @if($lp->type ==='morphing') selected @endif value="morphing">Morphing</option>
                                                    </select>
                                                    @error('type')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>

                                            </div>
                                            <div class="col-md-6">
                                                <div class="morphing collapse">

                                                    <label for="morph_rebill_days">Morphing Rebill Delay (days)</label>
                                                    <input type="number" class="form-control" placeholder="Number of days till next order" name="morph_rebill_days" value="30">
                                                    <p class="text-muted">
                                                        Morphing LPS will use defined campaign id first and after set number of days will create another order with the second campaign id defined
                                                    </p>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                    <div class="col-md-6">
                                        <h4 class="mb-3">Campaign Ids</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="campaign_id">Credit Card</label>
                                                    <input type="tel" class="form-control @error('campaign_id') is-invalid @enderror" id="campaign_id" name="campaign_id" value="{{$lp->campaign_id}}" placeholder="Enter Campaign Id">
                                                    @error('campaign_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                                <div class="morphing collapse">
                                                    <div class="form-group">
                                                        <label for="morph_campaign_id">Credit Card Morph</label>
                                                        <input type="tel" class="form-control" value="{{$lp->morph_campaign_id}}" name="morph_campaign_id" placeholder="Enter Campaign Id">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="campaign_id2">Prepaid Card</label>
                                                    <input type="tel" class="form-control @error('campaign_id2') is-invalid @enderror" value="{{$lp->campaign_id2}}" id="campaign_id2" name="campaign_id2" placeholder="Enter Campaign Id">
                                                    @error('campaign_id2')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                                <div class="morphing collapse">
                                                    <div class="form-group">
                                                        <label for="morph_campaign_id2">Prepaid Card Morph</label>
                                                        <input type="tel" class="form-control" value="{{$lp->morph_campaign_id2}}" name="morph_campaign_id2" placeholder="Enter Campaign Id">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="campaign_id3">Scrub</label>
                                                    <input type="tel" class="form-control @error('campaign_id3') is-invalid @enderror" value="{{$lp->campaign_id3}}" id="campaign_id3" name="campaign_id3" placeholder="Enter Campaign Id">
                                                    @error('campaign_id3')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                                <div class="morphing collapse">
                                                    <div class="form-group">
                                                        <label for="morph_campaign_id3">Scrub Morph</label>
                                                        <input type="tel" class="form-control" value="{{$lp->morph_campaign_id3}}" name="morph_campaign_id3" placeholder="Enter Campaign Id">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="campaign_id4">Master Card</label>
                                                    <input type="tel" class="form-control @error('campaign_id4') is-invalid @enderror" value="{{$lp->campaign_id4}}" id="campaign_id4" name="campaign_id4" placeholder="Enter Campaign Id">
                                                    @error('campaign_id4')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                                <div class="morphing collapse">
                                                    <div class="form-group">
                                                        <label for="morph_campaign_id4">Master Card Morph</label>
                                                        <input type="tel" class="form-control" value="{{$lp->morph_campaign_id4}}" name="morph_campaign_id4" placeholder="Enter Campaign Id">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <h4 class="mb-3">Product Ids</h4>
                                        <hr>
                                        <div class="row">

                                            <div class="col-md-12">
                                                <h6 class="mb-3 text-center">Single Sale based</h6>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Credit Card Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product1_id">Step 1 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id') is-invalid @enderror" value="{{$lp->product1_id}}" id="product1_id" name="product1_id" placeholder="Enter Product Id">
                                                                            @error('product1_id')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_morph') is-invalid @enderror" value="{{$lp->product1_id_morph}}" id="product1_id_morph" name="product1_id_morph" placeholder="Enter Product Id">
                                                                            @error('product1_id_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product2_id">Step 2 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id') is-invalid @enderror" value="{{$lp->product2_id}}" id="product2_id" name="product2_id" placeholder="Enter Product Id">
                                                                            @error('product2_id')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_morph') is-invalid @enderror" value="{{$lp->product2_id_morph}}" id="product2_id_morph" name="product2_id_morph" placeholder="Enter Product Id">
                                                                            @error('product2_id_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product3_id">Step 3 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id') is-invalid @enderror" value="{{$lp->product3_id}}" id="product3_id" name="product3_id" placeholder="Enter Product 3 Id">
                                                                            @error('product3_id')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>

                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_morph') is-invalid @enderror" value="{{$lp->product3_id_morph}}" id="product3_id_morph" name="product3_id_morph" placeholder="Enter Product 3 Id">
                                                                            @error('product3_id_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Prepaid Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c2">Step 1 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c2') is-invalid @enderror" value="{{$lp->product1_id_c2}}" id="product1_id_c2" name="product1_id_c2" placeholder="Enter Product Id">
                                                                            @error('product1_id_c2')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c2_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c2_morph') is-invalid @enderror" value="{{$lp->product1_id_c2_morph}}" id="product1_id_c2_morph" name="product1_id_c2_morph" placeholder="Enter Product Id">
                                                                            @error('product1_id_c2_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c2">Step 2 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c2') is-invalid @enderror" value="{{$lp->product2_id_c2}}" id="product2_id_c2" name="product2_id_c2" placeholder="Enter Product Id">
                                                                            @error('product2_id_c2')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c2_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c2_morph') is-invalid @enderror" value="{{$lp->product2_id_c2_morph}}" id="product2_id_c2_morph" name="product2_id_c2_morph" placeholder="Enter Product Id">
                                                                            @error('product2_id_c2_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c2">Step 3 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c2') is-invalid @enderror" value="{{$lp->product3_id_c2}}" id="product3_id_c2" name="product3_id_c2" placeholder="Enter Product Id">
                                                                            @error('product3_id_c2')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c2_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c2_morph') is-invalid @enderror" value="{{$lp->product3_id_c2_morph}}" id="product3_id_c2_morph" name="product3_id_c2_morph" placeholder="Enter Product Id">
                                                                            @error('product3_id_c2_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Scrub Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c3">Step 1 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c3') is-invalid @enderror" value="{{$lp->product1_id_c3}}" id="product1_id_c3" name="product1_id_c3" placeholder="Enter Product Id">
                                                                            @error('product1_id_c3')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c3_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c3_morph') is-invalid @enderror" value="{{$lp->product1_id_c3_morph}}" id="product1_id_c3_morph" name="product1_id_c3_morph" placeholder="Enter Product Id">
                                                                            @error('product1_id_c3_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c3">Step 2 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c3') is-invalid @enderror" value="{{$lp->product2_id_c3}}" id="product2_id_c3" name="product2_id_c3" placeholder="Enter Product Id">
                                                                            @error('product2_id_c3')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c3_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c3_morph') is-invalid @enderror" value="{{$lp->product2_id_c3_morph}}" id="product2_id_c3_morph" name="product2_id_c3_morph" placeholder="Enter Product Id">
                                                                            @error('product2_id_c3_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c3">Step 3 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c3') is-invalid @enderror" value="{{$lp->product3_id_c3}}" id="product3_id_c3" name="product3_id_c3" placeholder="Enter Product Id">
                                                                            @error('product3_id_c3')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c3_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c3_morph') is-invalid @enderror" value="{{$lp->product3_id_c3_morph}}" id="product3_id_c3_morph" name="product3_id_c3_morph" placeholder="Enter Product Id">
                                                                            @error('product3_id_c3_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">MasterCard Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c4">Step 1 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c4') is-invalid @enderror" value="{{$lp->product1_id_c4}}" id="product1_id_c4" name="product1_id_c4" placeholder="Enter Product Id">
                                                                            @error('product1_id_c4')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product1_id_c4_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product1_id_c4_morph') is-invalid @enderror" value="{{$lp->product1_id_c4_morph}}" id="product1_id_c4_morph" name="product1_id_c4_morph" placeholder="Enter Product Id">
                                                                            @error('product1_id_c4_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c4">Step 2 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c4') is-invalid @enderror" value="{{$lp->product2_id_c4}}" id="product2_id_c4" name="product2_id_c4" placeholder="Enter Product Id">
                                                                            @error('product2_id_c4')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col morphing collapse">
                                                                        <div class="form-group">
                                                                            <label for="product2_id_c4_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product2_id_c4_morph') is-invalid @enderror" value="{{$lp->product2_id_c4_morph}}" id="product2_id_c4_morph" name="product2_id_c4_morph" placeholder="Enter Product Id">
                                                                            @error('product2_id_c4_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c4">Step 3 Product Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c4') is-invalid @enderror" value="{{$lp->product3_id_c4}}" id="product3_id_c4" name="product3_id_c4" placeholder="Enter Product Id">
                                                                            @error('product3_id_c4')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col collapse morphing">
                                                                        <div class="form-group">
                                                                            <label for="product3_id_c4_morph">Morphing Id</label>
                                                                            <input type="tel" class="form-control @error('product3_id_c4_morph') is-invalid @enderror" value="{{$lp->product3_id_c4_morph}}" id="product3_id_c4_morph" name="product3_id_c4_morph" placeholder="Enter Product Id">
                                                                            @error('product3_id_c4_morph')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>



                                            </div>
                                            <div class="col-md-12">
                                                <h6 class="mb-3 text-center">Multiple Product based</h6>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Credit Card Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 1</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id">Product Id (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id') is-invalid @enderror" value="{{$lp->product1_7_id}}" id="product1_7_id" name="product1_7_id" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_morph">Morph (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_morph') is-invalid @enderror" value="{{$lp->product1_7_id_morph}}" id="product1_7_id_morph" name="product1_7_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id">Product Id (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id') is-invalid @enderror" value="{{$lp->product1_5_id}}" id="product1_5_id" name="product1_5_id" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_morph">Morph (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_morph') is-invalid @enderror" value="{{$lp->product1_5_id_morph}}" id="product1_5_id_morph" name="product1_5_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id">Product Id (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id') is-invalid @enderror" value="{{$lp->product1_3_id}}" id="product1_3_id" name="product1_3_id" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_morph">Morph (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_morph') is-invalid @enderror" value="{{$lp->product1_3_id_morph}}" id="product1_3_id_morph" name="product1_3_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id') is-invalid @enderror" value="{{$lp->product1_1_id}}" id="product1_1_id" name="product1_1_id" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_morph') is-invalid @enderror" value="{{$lp->product1_1_id_morph}}" id="product1_1_id_morph" name="product1_1_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 2</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id') is-invalid @enderror" value="{{$lp->product2_1_id}}" id="product2_1_id" name="product2_1_id" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_morph') is-invalid @enderror" value="{{$lp->product2_1_id_morph}}" id="product2_1_id_morph" name="product2_1_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id') is-invalid @enderror" value="{{$lp->product2_2_id}}" id="product2_2_id" name="product2_2_id" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_morph') is-invalid @enderror" value="{{$lp->product2_2_id_morph}}" id="product2_2_id_morph" name="product2_2_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 3</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id') is-invalid @enderror" value="{{$lp->product3_1_id}}" id="product3_1_id" name="product3_1_id" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_morph') is-invalid @enderror" value="{{$lp->product3_1_id_morph}}" id="product3_1_id_morph" name="product3_1_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id') is-invalid @enderror" value="{{$lp->product3_2_id}}" id="product3_2_id" name="product3_2_id" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_morph') is-invalid @enderror" value="{{$lp->product3_2_id_morph}}" id="product3_2_id_morph" name="product3_2_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>


                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 4</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id') is-invalid @enderror" value="{{$lp->product4_1_id}}" id="product4_1_id" name="product4_1_id" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_morph') is-invalid @enderror" value="{{$lp->product4_1_id_morph}}" id="product4_1_id_morph" name="product4_1_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id') is-invalid @enderror" value="{{$lp->product4_2_id}}" id="product4_2_id" name="product4_2_id" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_morph') is-invalid @enderror" value="{{$lp->product4_2_id_morph}}" id="product4_2_id_morph" name="product4_2_id_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Prepaid Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 1</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c2">Product Id (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c2') is-invalid @enderror" value="{{$lp->product1_7_id_c2}}" id="product1_7_id_c2" name="product1_7_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c2_morph">Morph (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c2_morph') is-invalid @enderror" value="{{$lp->product1_7_id_c2_morph}}" id="product1_7_id_c2_morph" name="product1_7_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c2">Product Id (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c2') is-invalid @enderror" value="{{$lp->product1_5_id_c2}}" id="product1_5_id_c2" name="product1_5_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c2_morph">Morph (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c2_morph') is-invalid @enderror" value="{{$lp->product1_5_id_c2_morph}}" id="product1_5_id_c2_morph" name="product1_5_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c2">Product Id (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c2') is-invalid @enderror" value="{{$lp->product1_3_id_c2}}" id="product1_3_id_c2" name="product1_3_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c2_morph">Morph (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c2_morph') is-invalid @enderror" value="{{$lp->product1_3_id_c2_morph}}" id="product1_3_id_c2_morph" name="product1_3_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c2">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c2') is-invalid @enderror" value="{{$lp->product1_1_id_c2}}" id="product1_1_id_c2" name="product1_1_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c2_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c2_morph') is-invalid @enderror" value="{{$lp->product1_1_id_c2_morph}}" id="product1_1_id_c2_morph" name="product1_1_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 2</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c2">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c2') is-invalid @enderror" value="{{$lp->product2_1_id_c2}}" id="product2_1_id_c2" name="product2_1_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c2_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c2_morph') is-invalid @enderror" value="{{$lp->product2_1_id_c2_morph}}" id="product2_1_id_c2_morph" name="product2_1_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c2">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c2') is-invalid @enderror" value="{{$lp->product2_2_id_c2}}" id="product2_2_id_c2" name="product2_2_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c2_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c2_morph') is-invalid @enderror" value="{{$lp->product2_2_id_c2_morph}}" id="product2_2_id_c2_morph" name="product2_2_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 3</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c2">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c2') is-invalid @enderror" value="{{$lp->product3_1_id_c2}}" id="product3_1_id_c2" name="product3_1_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c2_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c2_morph') is-invalid @enderror" value="{{$lp->product3_1_id_c2_morph}}" id="product3_1_id_c2_morph" name="product3_1_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c2">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c2') is-invalid @enderror" value="{{$lp->product3_2_id_c2}}" id="product3_2_id_c2" name="product3_2_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c2_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c2_morph') is-invalid @enderror" value="{{$lp->product3_2_id_c2_morph}}" id="product3_2_id_c2_morph" name="product3_2_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>


                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 4</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c2">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c2') is-invalid @enderror" value="{{$lp->product4_1_id_c2}}" id="product4_1_id_c2" name="product4_1_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c2_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c2_morph') is-invalid @enderror" value="{{$lp->product4_1_id_c2_morph}}" id="product4_1_id_c2_morph" name="product4_1_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c2">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c2') is-invalid @enderror" value="{{$lp->product4_2_id_c2}}" id="product4_2_id_c2" name="product4_2_id_c2" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c2')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c2_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c2_morph') is-invalid @enderror" value="{{$lp->product4_2_id_c2_morph}}" id="product4_2_id_c2_morph" name="product4_2_id_c2_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c2_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">Scrub Campaign</h6>
                                                            </div>
                                                            <div class="card-body">

                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 1</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c3">Product Id (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c3') is-invalid @enderror" value="{{$lp->product1_7_id_c3}}" id="product1_7_id_c3" name="product1_7_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c3_morph">Morph (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c3_morph') is-invalid @enderror" value="{{$lp->product1_7_id_c3_morph}}" id="product1_7_id_c3_morph" name="product1_7_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c3">Product Id (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c3') is-invalid @enderror" value="{{$lp->product1_5_id_c3}}" id="product1_5_id_c3" name="product1_5_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c3_morph">Morph (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c3_morph') is-invalid @enderror" value="{{$lp->product1_5_id_c3_morph}}" id="product1_5_id_c3_morph" name="product1_5_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c3">Product Id (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c3') is-invalid @enderror" value="{{$lp->product1_3_id_c3}}" id="product1_3_id_c3" name="product1_3_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c3_morph">Morph (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c3_morph') is-invalid @enderror" value="{{$lp->product1_3_id_c3_morph}}" id="product1_3_id_c3_morph" name="product1_3_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c3">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c3') is-invalid @enderror" value="{{$lp->product1_1_id_c3}}" id="product1_1_id_c3" name="product1_1_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c3_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c3_morph') is-invalid @enderror" value="{{$lp->product1_1_id_c3_morph}}" id="product1_1_id_c3_morph" name="product1_1_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 2</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c3">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c3') is-invalid @enderror" value="{{$lp->product2_1_id_c3}}" id="product2_1_id_c3" name="product2_1_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c3_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c3_morph') is-invalid @enderror" value="{{$lp->product2_1_id_c3_morph}}" id="product2_1_id_c3_morph" name="product2_1_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c3">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c3') is-invalid @enderror" value="{{$lp->product2_2_id_c3}}" id="product2_2_id_c3" name="product2_2_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c3_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c3_morph') is-invalid @enderror" value="{{$lp->product2_2_id_c3_morph}}" id="product2_2_id_c3_morph" name="product2_2_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 3</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c3">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c3') is-invalid @enderror" value="{{$lp->product3_1_id_c3}}" id="product3_1_id_c3" name="product3_1_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c3_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c3_morph') is-invalid @enderror" value="{{$lp->product3_1_id_c3_morph}}" id="product3_1_id_c3_morph" name="product3_1_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c3">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c3') is-invalid @enderror" value="{{$lp->product3_2_id_c3}}" id="product3_2_id_c3" name="product3_2_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c3_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c3_morph') is-invalid @enderror" value="{{$lp->product3_2_id_c3_morph}}" id="product3_2_id_c3_morph" name="product3_2_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>


                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 4</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c3">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c3') is-invalid @enderror" value="{{$lp->product4_1_id_c3}}" id="product4_1_id_c3" name="product4_1_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c3_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c3_morph') is-invalid @enderror" value="{{$lp->product4_1_id_c3_morph}}" id="product4_1_id_c3_morph" name="product4_1_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c3">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c3') is-invalid @enderror" value="{{$lp->product4_2_id_c3}}" id="product4_2_id_c3" name="product4_2_id_c3" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c3')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c3_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c3_morph') is-invalid @enderror" value="{{$lp->product4_2_id_c3_morph}}" id="product4_2_id_c3_morph" name="product4_2_id_c3_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c3_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0 text-center">MasterCard Campaign</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 1</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c4">Product Id (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c4') is-invalid @enderror" value="{{$lp->product1_7_id_c4}}" id="product1_7_id_c4" name="product1_7_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_7_id_c4_morph">Morph (x7)</label>
                                                                                            <input type="tel" class="form-control @error('product1_7_id_c4_morph') is-invalid @enderror" value="{{$lp->product1_7_id_c4_morph}}" id="product1_7_id_c4_morph" name="product1_7_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_7_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c4">Product Id (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c4') is-invalid @enderror" value="{{$lp->product1_5_id_c4}}" id="product1_5_id_c4" name="product1_5_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_5_id_c4_morph">Morph (x5)</label>
                                                                                            <input type="tel" class="form-control @error('product1_5_id_c4_morph') is-invalid @enderror" value="{{$lp->product1_5_id_c4_morph}}" id="product1_5_id_c4_morph" name="product1_5_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_5_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c4">Product Id (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c4') is-invalid @enderror" value="{{$lp->product1_3_id_c4}}" id="product1_3_id_c4" name="product1_3_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_3_id_c4_morph">Morph (x3)</label>
                                                                                            <input type="tel" class="form-control @error('product1_3_id_c4_morph') is-invalid @enderror" value="{{$lp->product1_3_id_c4_morph}}" id="product1_3_id_c4_morph" name="product1_3_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_3_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c4">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c4') is-invalid @enderror" value="{{$lp->product1_1_id_c4}}" id="product1_1_id_c4" name="product1_1_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product1_1_id_c4_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product1_1_id_c4_morph') is-invalid @enderror" value="{{$lp->product1_1_id_c4_morph}}" id="product1_1_id_c4_morph" name="product1_1_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product1_1_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 2</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c4">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c4') is-invalid @enderror" value="{{$lp->product2_1_id_c4}}" id="product2_1_id_c4" name="product2_1_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_1_id_c4_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product2_1_id_c4_morph') is-invalid @enderror" value="{{$lp->product2_1_id_c4_morph}}" id="product2_1_id_c4_morph" name="product2_1_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_1_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c4">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c4') is-invalid @enderror" value="{{$lp->product2_2_id_c4}}" id="product2_2_id_c4" name="product2_2_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product2_2_id_c4_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product2_2_id_c4_morph') is-invalid @enderror" value="{{$lp->product2_2_id_c4_morph}}" id="product2_2_id_c4_morph" name="product2_2_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product2_2_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 3</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c4">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c4') is-invalid @enderror" value="{{$lp->product3_1_id_c4}}" id="product3_1_id_c4" name="product3_1_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_1_id_c4_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product3_1_id_c4_morph') is-invalid @enderror" value="{{$lp->product3_1_id_c4_morph}}" id="product3_1_id_c4_morph" name="product3_1_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_1_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c4">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c4') is-invalid @enderror" value="{{$lp->product3_2_id_c4}}" id="product3_2_id_c4" name="product3_2_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product3_2_id_c4_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product3_2_id_c4_morph') is-invalid @enderror" value="{{$lp->product3_2_id_c4_morph}}" id="product3_2_id_c4_morph" name="product3_2_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product3_2_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>


                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="card">
                                                                            <div class="card-header">
                                                                                <h6 class="mb-0 text-center">Step 4</h6>
                                                                            </div>
                                                                            <div class="card-body">
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c4">Product Id (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c4') is-invalid @enderror" value="{{$lp->product4_1_id_c4}}" id="product4_1_id_c4" name="product4_1_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_1_id_c4_morph">Morph (x1)</label>
                                                                                            <input type="tel" class="form-control @error('product4_1_id_c4_morph') is-invalid @enderror" value="{{$lp->product4_1_id_c4_morph}}" id="product4_1_id_c4_morph" name="product4_1_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_1_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="row">
                                                                                    <div class="col">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c4">Product Id (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c4') is-invalid @enderror" value="{{$lp->product4_2_id_c4}}" id="product4_2_id_c4" name="product4_2_id_c4" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c4')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col morphing collapse">
                                                                                        <div class="form-group">
                                                                                            <label for="product4_2_id_c4_morph">Morph (x2)</label>
                                                                                            <input type="tel" class="form-control @error('product4_2_id_c4_morph') is-invalid @enderror" value="{{$lp->product4_2_id_c4_morph}}" id="product4_2_id_c4_morph" name="product4_2_id_c4_morph" placeholder="Enter Product Id">
                                                                                            @error('product4_2_id_c4_morph')
                                                                                            <span class="invalid-feedback" role="alert">
                                                                                                <strong>{{ $message }}</strong>
                                                                                            </span>
                                                                                            @enderror
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>




                                            </div>

                                        </div>
                                        <h4 class="mb-3">Conversion Pixels</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pixels_up1">Pixels that fire on Upsell1
                                                        page</label>
                                                    <textarea class="form-control @error('pixels_up1') is-invalid @enderror" id="pixels_up1" name="pixels_up1" placeholder="Enter Conversion Pixel here">{{$lp->pixels_up1}}</textarea>
                                                    @error('pixels_up1')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror

                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pixels_up2">Pixels that fire on Thank You
                                                        page (!! only if upsell1 is baught !!)</label>
                                                    <textarea class="form-control @error('pixels_up2') is-invalid @enderror" id="pixels_up2" name="pixels_up2" placeholder="Enter Conversion Pixel here">{{$lp->pixels_up2}}</textarea>
                                                    @error('pixels_up2')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror

                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="text-muted text-center"><small>Include all pixels
                                                        with the dynamic variable in [[ yourVariableHere ]].
                                                        It's imperative that the variable is surrounded by
                                                        double square brackets [[]]!</small></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-flat btn-block">Submit</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <!--/.col (left) -->
            </div>
            <!-- /.row -->
        </div>
    </div>
</div>
@stop
@section('scripts')
<script>
    $('*[name="type"]').change(function(){
        $val = $(this).val();
        if($val === 'morphing'){
            $('.morphing').collapse('show');
        }else{
            $('.morphing').collapse('hide');
        }
    });
    @if($lp->type ==='morphing') 
        $('*[name="type"]').trigger('change');
    @endif
</script>
@endsection