@extends('layouts.app')
@section('pagetitle', 'LPs Manager')
@section('content')
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                @if(session('status'))
                <div class="alert alert-success" role="alert">
                    {{ session('status') }}
                </div>
                @endif
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">LPs Table</h3>
                        <div class="card-tools">
                            <a href="{{route('addlp')}}" class="btn btn-success btn-sm"><i class="fa fa-user-plus fa-fw"></i> Add New </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Name</th>
                                    <th>Identifier</th>
                                    <th>Url</th>
                                    <th>Type</th>
                                    <th>Orders</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $el)
                                <tr>
                                    <td>{{$el->id}}</td>
                                    <td>{{$el->name}}</td>
                                    <td>{{$el->token}}</td>
                                    <td><a href="{{$el->url}}" target="_blank">{{$el->url}}</a></td>
                                    <td>{{$el->type}}</td>
                                    <td>{{$el->orders->count()}}</td>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="{{ route('editlp', $el->id) }}" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{route('lpDestroy',$el->id)}}" id="ordr_{{$el->id}}" method="GET">
                                                @csrf
                                                <input type="hidden" name="id" value="{{$el->id}}">
                                                <a href="#" data-toggle="modal" data-target="#deleteModal" onclick="setModal('#ordr_{{$el->id}}')" class="btn btn-sm btn-danger p-1 deletebtn">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<div class="modal fade" id="deleteModal" data-source="" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content bg-danger">
            <div class="modal-header">
                <h4 class="modal-title">Are you Sure?</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>The record will be deleted and You cannot undo this!</p>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-outline-light" data-dismiss="modal">No</button>
                <button type="button" id="confirm" class="btn btn-outline-light">Yes, Delete</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@endsection

@section('styles')
@stop
@section('scripts')

<script>
    $(function () {
         $('#confirm').click(function(){
            $tar = $('#deleteModal').data('source');
            // console.log($tar);
            $($tar).submit();
        });

    })
    function setModal($id){
        $('#deleteModal').attr('data-source', $id);
    }
</script>
@stop