@extends('layouts.app')
@section('pagetitle', 'Affiliates Manager')
@section('content')
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                @if(session('status'))
                <div class="alert alert-success" role="alert">
                    {{ session('status') }}
                </div>
                @endif
                <div class="card">
                    <div class="card-header d-flex bg-primary align-items-center">
                        <h3 class="card-title mb-0">Affiliates Table</h3>
                        <div class="card-tools">
                            <a href="{{route('addaff')}}" class="btn btn-success btn-sm"><i
                                    class="fa fa-user-plus fa-fw"></i> Add New </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>LP</th>
                                    <th>AFF ID</th>
                                    <th>Percent %</th>
                                    <th>Start After</th>
                                    <th>Current Sales</th>
                                    <th>Scrub Sales</th>
                                    <th style="width: 40px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $el)
                                <tr>
                                    <td>{{$el->id}}</td>
                                    <td>{{$el->parent->name}}</td>
                                    <td>@if($el->aff_id == null) (default) @else {{$el->aff_id}} @endif</td>
                                    <td>{{$el->percent}} %</td>
                                    <td>{{$el->start_after}} sales</td>
                                    <td>{{$el->salesCounter}} sales</td>
                                    <td>{{$el->scrubCounter}} sales</td>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="{{ route('editaff', $el->id) }}" class="btn btn-sm btn-success p-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{route('deleteaff', $el->id)}}" method="POST">
                                                @csrf
                                                    <button type="submit" class="btn btn-sm btn-danger p-1">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
@endsection