@extends('layouts.app')
@section('pagetitle', 'Add New Affiliate')
@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- general form elements -->
                    <div class="card card-primary">
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form role="form" method="post" action="{{route('storeaff')}}">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4 class="mb-3">Affiliate Settings</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="lp_id">LP</label>
                                                    <select class="form-control  @error('lp_id') is-invalid @enderror" name="lp_id">
                                                        @foreach($lps as $lp)
                                                        <option value="{{$lp->id}}">{{$lp->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('lp_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="aff_id">Affiliate Id</label>
                                                    <input type="text"
                                                        class="form-control @error('aff_id') is-invalid @enderror"
                                                        id="aff_id" name="aff_id" placeholder="Enter AffId">
                                                    @error('aff_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="percent">Scrub %</label>
                                                    <input type="text"
                                                        class="form-control @error('percent') is-invalid @enderror"
                                                        id="percent" name="percent" placeholder="Enter Scrub %">
                                                    @error('percent')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="start_after">Scrub after # sales</label>
                                                    <input type="text"
                                                        class="form-control @error('start_after') is-invalid @enderror"
                                                        id="start_after" name="start_after"
                                                        placeholder="Enter after how many sales the scrub fires">
                                                    @error('start_after')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                      
                                    </div>

                                </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-flat btn-block">Submit</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <!--/.col (left) -->
            </div>
            <!-- /.row -->
        </div>
    </div>
</div>
@stop
