<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderRetryCustomsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_retry_customs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('cycle');
            $table->integer('customerId');
            $table->string('orderId');
            $table->string('date');
            $table->string('cvv')->nullable();
            $table->string('processed')->nullable();
            $table->string('campaignId');
            $table->string('product1_id');
            $table->string('product2_id')->nullable();  
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_retry_customs');
    }
}
