<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAffiliatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {       
        Schema::create('affiliates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('lp_id')->unsigned();
            $table->foreign('lp_id')->references('id')->on('l_p_s')->onDelete('cascade');
            $table->string('aff_id')->nullable();
            $table->integer('percent');
            $table->integer('start_after');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('affiliates');
    }
}
