<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('agentUserId');
            $table->string('campaignId');
            $table->string('country');
            $table->string('customerId');
            $table->string('dateCreated')->nullable();
            $table->string('dateUpdated');
            $table->string('emailAddress');
            $table->string('firstName');
            $table->string('lastName');
            $table->string('ipAddress');
            $table->string('orderId');
            $table->string('orderStatus');
            $table->string('orderType');
            $table->string('phoneNumber');
            $table->string('address1');
            $table->string('city');
            $table->string('state');
            $table->string('postalCode');
            $table->string('shipFirstName');
            $table->string('shipLastName');
            $table->string('shipAddress1')->nullable();
            $table->string('shipAddress2')->nullable();
            $table->string('shipCity')->nullable();
            $table->string('shipState')->nullable();
            $table->string('shipPostalCode')->nullable(); //start step 1 values
            $table->string('sourceId')->nullable();
            $table->string('sourceValue1')->nullable();
            $table->string('sourceValue2')->nullable();
            $table->string('sourceValue3')->nullable();
            $table->string('shipCarrier')->nullable();
            $table->string('shipMethod')->nullable();
            $table->string('reviewStatus')->nullable();
            $table->string('totalAmount')->nullable();
            $table->string('campaignName')->nullable();
            $table->string('name')->nullable();
            $table->string('paySource')->nullable();
            $table->string('cardType')->nullable();
            $table->string('cardLast4')->nullable();
            $table->string('cardExpiryDate')->nullable();
            $table->string('basePrice')->nullable();
            $table->string('baseShipping')->nullable();
            $table->string('discountPrice')->nullable();
            $table->string('amountPaid')->nullable();
            $table->string('totalDiscount')->nullable();
            $table->integer('upsells')->default(0);
            $table->string('items')->nullable();
            $table->integer('lp_id')->unsigned();
            $table->foreign('lp_id')->references('id')->on('l_p_s')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
