<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OrderRetry extends Model
{
    protected $fillable = [
        'order_id','processed','cycle','customerId','orderId','date','product1_id','product2_id'
    ];
    public function order(){
        return $this->belongsTo('App\Order');
    }
    public function scopeNotProcessed($query){
        return $query->whereNull('processed');
    }
}
