<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'agentUserId',
        'campaignId',
        'country',
        'customerId',
        'dateCreated',
        'dateUpdated',
        'emailAddress',
        'firstName',
        'lastName',
        'ipAddress',
        'orderId',
        'orderStatus',
        'orderType',
        'phoneNumber',
        'shipFirstName',
        'shipLastName', // more ship values
        'shipAddress1',
        'shipAddress2',
        'shipCity',
        'shipState',
        'shipPostalCode',
        'address1',
        'city',
        'state',
        'postalCode',
        'lp_id', //start step 1 values
        'sourceId',
        'sourceValue1',
        'sourceValue2',
        'sourceValue3',
        'shipCarrier',
        'shipMethod',
        'reviewStatus',
        'totalAmount',
        'campaignName',
        'name',
        'paySource',
        'cardType',
        'cardLast4',
        'cardExpiryDate',
        'cardNumber',
        'cardCVV',
        'basePrice',
        'baseShipping',
        'discountPrice',
        'amountPaid',
        'totalDiscount',
        'items',
        'upsells',
        'pixelFired',
        'created_at',
        'scrubbedId',
        'stage'

    ];
    public function parent()
    {
        return $this->hasOne(LP::class, 'id', 'lp_id');
    }
    public function scopeConverted($query)
    {
        return $query->where('orderStatus', 'COMPLETE');
    }
}
