<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Hash;
class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function update(Request $request){
        $user = auth()->user();
        $this->validate($request,[
            'name'=>'required|string|max:191',
            'email'=>'required|email',
            'password'=>'sometimes',
        ]);
        if(empty($request->password)){
            $request->merge(['password'=>Hash::make($user->password)]);
        }
        if(!empty($request->password)){
            $request->merge(['password'=>Hash::make($request['password'])]);
        }
        $user->update($request->all());
        return redirect()->route('home');
    }
}
