<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Order;
use App\LP;
use Log;
use Datatables;
use Cookie;
class OrdersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function editorder($id){
        $order = Order::findOrFail($id);   
        $parent = $order->parent;    
        return view('orders.show',compact('order','parent'));
    }
    public function getClient(Request $request){
        $el = LP::token($request->token)->first();  
        $data = $request->all();
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/customer/query/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        if($err){
            Log::error('|| Client data request failed with data: ' . $err);
        }
        curl_close($curl);
        Log::notice('|| Client data request succeded with data: ' . $response);

        return redirect()->back()->with('client', $response);
    }

    public function updateCard(Request $request){
        $el = LP::token($request->token)->first();  
        $data = $request->all();
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        Log::notice('|| Update Card data request with data: ' . json_encode($request->all()));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/customer/cardupdate/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($err){
            Log::error('|| Update Card data request with data: ' . $err);
            return redirect()->back()->with('cardUpdated', $err);
        }
        Log::notice('|| Update Card data request with data: ' . $response);
        return redirect()->back()->with('cardUpdated', $response);
    }
    public function rerunDeclined(Request $request){
        $el = LP::token($request->token)->first();  
        $data = $request->all();
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        Log::notice('|| Rerun Declined request with data: ' . json_encode($request->all()));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/rerun/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($err){
            return redirect()->back()->with('rebilled', $err);
            Log::error('|| Rerun Declined Order failed with data: ' . $err);
        }
        Log::notice('|| Rerun Declined Order succeded with data: ' . $response);

        return redirect()->back()->with('rebilled', $response);
    }
    public function destroy(Request $request)
    {
        $id = $request->id;
        $cookie = $request->searchinput;
        $el = Order::findOrFail($id);
        $el->delete();
        return redirect()->back()->withCookie(Cookie::make('searchTerm',  $cookie, '100'));
    }
    public function importOrder(Request $request)
    {
        $el = LP::token($request->token)->first();  
        $data = [
            'orderId'=> $request->orderId,
        ];
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/query/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($err){
            return redirect()->back()->with('rebilled', $err);
        }
        $order = Order::where('orderId', $data['orderId'])->first();
        $reply = json_decode($response);
        Log::notice('|| Order Refresh response data: ' . json_encode($reply));

        $order->update([
            'orderStatus'=> $reply->message->data[0]->orderStatus,
            'orderId'=>$reply->message->data[0]->orderId
        ]);
        // $order->orderStatus = $reply->message->data[0]->orderStatus;
        return redirect()->back();
    }

}
