<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\LP;
class LPsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function storeData(Request $request)
    {
            $this->validate($request,[
                'name' => 'required|string|max:191',
                'token'=>'required|unique:l_p_s,token',
                'campaign_id'=>'required',
                'api_user'=>'required',
                'api_password'=>'required',
            ]);
            $el = LP::create($request->all());
            return redirect()->route('lps');
    }
    public function editlp($id){
        $lp = LP::findOrFail($id);
        return view('LPS.show',compact('lp'));
    }
    public function updateData(Request $request, $id)
    {
        $el = LP::findOrFail($id);
        $this->validate($request,[
            'name' => 'required|string|max:191',
            'token'=>'required|unique:l_p_s,token,'.$el->id,
            'campaign_id'=>'required',
            'api_user'=>'required',
            'api_password'=>'required',

        ]);
            $el->update($request->all());
            return redirect()->route('lps');

    }

    // public function updateOrder(Request $request, $id)
    // {
    //     $el = Order::findOrFail($id);
    //     $this->validate($request,[
    //         'status' => 'required|string|max:191',
    //     ]);
    //         $el->update($request->all());
    // }
    public function destroy($id)
    {
        $el = LP::findOrFail($id);
        $el->delete();
        return redirect()->back();
    }

  
}
