<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\LP;
use App\Order;
use App\OrderRetry;
use App\OrderRetryCustom;
use App\Affiliate;
use App\Visit;
use Log;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index($id=null)
    {
        $page = LP::find($id);
        if(!$page){
            $page= LP::first();
            if(!$page){
                return redirect()->route('addlp');
            }
        }
        $conversion = $page->orders()->where('orderStatus', 'COMPLETE')->count();
        $partial = $page->orders()->where('orderStatus', 'PARTIAL')->count();
        $total = $page->orders()->count();
        if($total > 0){
            $percent = number_format($conversion / $total * 100,0);
        }else{
            $percent = 0;
        }
        $revenue = 0;
        foreach($page->orders as $order){
            $revenue = $revenue + $order->amountPaid;
        }
        $data = [];
        $data['orders']= $total;
        $data['bounce']['percent'] = $percent;
        $data['bounce']['conversion'] = $conversion;
        $data['bounce']['partial'] = $partial;
        $data['visits']=Visit::where('token', $page->token)->count();
        $data['revenue']=$revenue;
        $data['hasUpsale']=$page->orders()->where('upsells', '>=', 1)->count();
        $data['noUpsale']=$page->orders()->where('upsells', '<', 1)->count();
        return view('home', compact('page','data'));
    }
    public function filemanage()
    {
        return view('filemanage');
    }
    public function addlp(){
        return view('LPS.create');
    }
    public function lpmanage()
    {
       $data = LP::with('orders')->get();
//$data = Order::all();
        return view('LPS.index',compact('data'));
    }
    public function ordermanage($id)
    {
        $page = LP::find($id);

        $data = $page->orders()->Converted()->latest()->paginate(500);
        return view('orders.index',compact('page','data'));
    }
    public function ordermanageall($id)
    {
        $page = LP::find($id);
        $data =$page->orders()->latest()->paginate(500);
        return view('orders.index',compact('page','data'));
    }
    public function affmanage()
    {
        $data = Affiliate::all();
        // update affiliate data 
        // get lp scrub cid
        // foreach($data as $aff){
        //     $scrubId = LP::findOrFail($aff->lp_id)->campaign_id3;
        //     // dd(Order::where('sourceId', $aff->aff_Id)->where('lp_id', $aff->lp_id)->count());
        //     // dd($aff->aff_Id);
        //     $aff->salesCounter = Order::where('sourceId', $aff->aff_Id)->where('lp_id', $aff->lp_id)->count();
        //     $aff->scrubCounter = Order::where('sourceId', $aff->aff_Id)->where('campaignId', $scrubId)->count();
        //     $aff->update();
        // };
        // $data = Affiliate::all();

        
        return view('AFF.index',compact('data'));
    }
    public function addAff(){
        $lps = LP::all();
        return view('AFF.create', compact('lps'));
    }
    public function profile(){
        $user = auth()->user();
        return view('user', compact('user'));
    }
    public function importOrders(){
        $orders = OrderRetry::notProcessed()->get();
        return view('orders.import', compact('orders','notFound'));
    }

    public function handleImport(Request $request){
        $this->validate($request,[
            'file' => 'required|file'
        ]);
        $path = $request->file('file')->getRealPath();
        $csv = array_map('str_getcsv', file($path));        
        $i = 0;
        $orders = [];
        $notFound = [];
        foreach($csv as $row){
            if(count($row) > 5){
                if($i >= 1 && $row[1] != ''){
                    $id = $row[1];
                    $order = Order::where('customerId', $row[6])->first();
                    if($order){
                        // $retry = OrderRetry::where('order_id', $order->id)->first();
                        // if(!$retry){
                            $orders[]= OrderRetry::create([
                                'order_id'=>$order->id,
                                'cycle'=>$row[28],
                                'customerId'=>$row[6],
                                'orderId'=>$id,
                                'date'=>$row[0],
                                'product1_id'=>$row[70],
                                'product2_id'=>$row[75]?$row[75]:null
                            ]);
                        // }else{
                            // $orders[]= $retry->update([
                            //     'order_id'=>$order->id,
                            //     'cycle'=>$row[28],
                            //     'customerId'=>$row[6],
                            //     'orderId'=>$id,
                            //     'date'=>$row[0],
                            //     'product1_id'=>$row[70],
                            //     'product2_id'=>$row[75]?$row[75]:null
                            // ]);
                        // }
                    }else{
                        $notFound[] = $id;
                    }
                }
                $i++;        
            }
        }
        return redirect()->route('importOrders')->with( ['notFound' => $notFound] );


    }
    public function clearImport(){
        $orders = OrderRetry::notProcessed()->get();
        foreach ($orders as $order){
            $order->delete();
        }
        return redirect()->route('importOrders');
    }

    // retry failed orders
    public function retryOrder(Request $request){
        $retry = OrderRetry::findOrFail($request->id);
        $order = $retry->order;
        $payload = [
            'loginId'=>$order->parent->api_user,
            'password'=>$order->parent->api_password,
            'customerId'=>$request->customerId,
            'campaignId'=> $request->campaignId,
            'paySource'=>'ACCTONFILE',
            'cardSecurityCode'=>$retry->order->cardCVV

        ];
        $upsellCount = 0;
        $prod1;
        $prod2;
                $cycle = $retry->cycle;
                if($retry->product1_id == 170){
                    if($cycle == 2){
                        $prod1 = 643;
                    }else{
                        $prod1 = 658;
                    }
                }
                if($retry->product1_id == 115){
                    if($cycle == 2){
                        $prod1 = 642;
                    }else{
                        $prod1 = 657;
                    }
                }
                if($retry->product2_id != null){
                    if($retry->product2_id == 170){
                        if($cycle == 2){
                            $prod2 = 643;
                        }else{
                            $prod2 = 658;
                        }
                    }
                    if($retry->product2_id == 115){
                        if($cycle == 2){
                            $prod2 = 642;
                        }else{
                            $prod2 = 657;
                        }
                    }
                    $upsellCount++;                    
                }                
                switch($upsellCount){
                    case 0:
                        $payload['product1_id'] = $prod1;
                    break;
                    default:
                        $payload['product1_id'] = $prod1;
                        $payload['product2_id'] = $prod2;
                }           
        $retry->processed = 1;
        $retry->save();
        // return $payload;
        return $this->newOrder($payload);
    }
   
    protected function newOrder($payload){
        // return $payload;
        Log::notice('|| Order retry called');

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($payload),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,	
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Order request failed with error ' . $err);
          return "cURL Error #:" . $err;
        } 
        Log::notice('|| Order retry complete '.json_encode($response));

        return response($response);
    }


    public function importCustomOrders(){
        $orders = OrderRetryCustom::notProcessed()->paginate(500);
        $total = count(OrderRetryCustom::all());
        $notProcessed = count(OrderRetryCustom::notProcessed()->get());
        return view('orders.customimport', compact('orders','total','notProcessed'));
    }
    public function handleImportCustom(Request $request){
        $this->validate($request,[
            'file' => 'required|file'
        ]);
        $path = $request->file('file')->getRealPath();
        $csv = array_map('str_getcsv', file($path));        
        $i = 0;
        $orders = [];        
        // dd($csv);
        foreach($csv as $row){
            if(count($row) > 5){
                if($i >= 1 && $row[1] != ''){
                    $id = $row[1];
                    $date = $row[0];
                    $orders[]= OrderRetryCustom::create([
                        'cycle'=>$row[28],
                        'customerId'=>$row[6],
                        'orderId'=>$id,
                        'date'=>$row[0],
                        'cvv'=>is_numeric($row[53])?$row[53]:null,
                        'campaignId'=>$row[3],
                        'product1_id'=>$row[71],
                        'product2_id'=>$row[76]?$row[76]:null
                    ]);                       
                }
                $i++;        
            }
        }
        return redirect()->route('importOrdersCustom');


    }
    public function retryOrderCustom(Request $request){
        $retry = OrderRetryCustom::findOrFail($request->id);
        $payload = [
            'loginId'=>'conceptol_api',
            'password'=>'Qazwsx@12',
            'customerId'=>$retry->customerId,
            'campaignId'=> $retry->campaignId,
            'paySource'=>'ACCTONFILE',
            'cardSecurityCode'=>$retry->cardCVV,
        ];
        $payload['product1_id']=$retry->product1_id;
        if($retry->product2_id){
        $payload['product2_id']=$retry->product2_id;
        }
                 
        $retry->processed = 1;
        $retry->save();
        return $this->newOrder($payload);
    }
}
