<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Affiliate;
use App\LP;
use Log;
class AffiliateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function storeData(Request $request)
    {
            $this->validate($request,[
                'lp_id' => 'required',
                // 'aff_id'=>'required',
                'percent'=>'required',
                'start_after'=>'required',
            ]);
            $el = Affiliate::create($request->all());
            return redirect()->route('affmanage');
    }
    public function editaff($id){
        $aff = Affiliate::findOrFail($id);
        $lps = LP::all();
        return view('AFF.show',compact('aff','lps'));
    }
    public function updateData(Request $request, $id)
    {
        $el = Affiliate::findOrFail($id);
        $this->validate($request,[
            'lp_id' => 'required',
                // 'aff_id'=>'required',
                'percent'=>'required',
                'start_after'=>'required',

        ]);
            $el->update($request->all());
            Log::notice('Affiliate update '. json_encode($request->all()));
            return redirect()->route('affmanage');

    }
    public function deleteAff(Request $request, $id){
        $el = Affiliate::findOrFail($id);
        $el->delete();
        return redirect()->back();
    }
}
