<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LP;
use App\Order;
use App\Affiliate;
use Log;
use Carbon\Carbon;
use App\Visit;
class RequestsController extends Controller
{
    public function feedLp($id){
        $el = LP::token($id)->with('affiliates')->first();
        if ($el){
            return  $el;
        }else{
            return 'Wrong Credentials or no valid token found';
        }     
    }
    public function getProspect(Request $request){
        $this->validate($request,[
            'campaignId'=>'required',
            'emailAddress'=>'required|email',
            'phoneNumber'=>'required',
            'ipAddress'=>'required',
            'token'=>'required'
            ]);
      
        // record visit data
        $visits = Visit::where('ip',  $request->ipAddress)->get();
        // return response($visits);
        if($visits->count() == 0){
            Visit::create([
                'ip'=>$request->ipAddress,
                'token'=>$request->token
            ]);
        }
        // end visit
        $el = LP::token($request->token)->first();  
		
        $data = $request->all();
        if(isset($data['url']) && strtok($data['url']) != $el->url || $el->url == null){
            $el->url = strtok($data['url'], '?');
            $el->save();
        }
        Log::notice('|| Prospect request for LP '. $el->name. ' with data: ' . json_encode($data));
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        // if($data['campaignId'] != $el->campaign_id){
        //     $data['affId'] = null;
        // }
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/leads/import/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Prospect request for LP '. $el->name. ' failed with error ' . $err);
          return "cURL Error #:" . $err;
        } else {
            $reply = json_decode($response);
            if($reply->result == 'ERROR'){
                Log::error('|| Prospect request for LP '.$el->name . ' Result: '. $response);
                return $response;
            }
            if($reply->result == 'SUCCESS'){
                if (!isset($reply->message->dateCreated)){
                    $dateCreated = Carbon::now();
                }else{
                    $dateCreated = $reply->message->dateCreated;
                }
                $order = Order::create([
                    'agentUserId'=>$reply->message->agentUserId,
                    'campaignId'=>$reply->message->campaignId,
                    'country'=>'US',
                    'customerId'=>$reply->message->customerId,
                    'dateCreated'=>$dateCreated,
                    'dateUpdated'=>$reply->message->dateUpdated,
                    'emailAddress'=>$reply->message->emailAddress,
                    'firstName'=>$reply->message->firstName,
                    'lastName'=>$reply->message->lastName,
                    'postalCode'=>$reply->message->postalCode,
                    'ipAddress'=>$reply->message->ipAddress,
                    'orderId'=>$reply->message->orderId,
                    'orderStatus'=>$reply->message->orderStatus,
                    'orderType'=>$reply->message->orderType,
                    'phoneNumber'=>$reply->message->phoneNumber,
                    'address1'=>$reply->message->address1,
                    'city'=>$reply->message->city,
                    'state'=>$reply->message->state,
                    'shipFirstName'=>$reply->message->shipFirstName,
                    'shipLastName'=>$reply->message->shipLastName,
                    'lp_id'=>$el->id, 
                    'sourceId'=>$request->affId,
                    'sourceValue1'=>$request->sourceValue1,
                    'sourceValue2'=>$request->sourceValue2,
                    'sourceValue3'=>$request->sourceValue3,
                    'scrubbedId'=>$request->scrubbedId
                ]); 
                Log::info('|| Prospect request for LP '.$el->name . ' with data '.json_encode($data).' succeded with Result: '. $response);

                   
                return $response;
            }
        }
    }
    
    public function newOrderWithProspect(Request $request){
        
        $this->validate($request,[
            'id'=>'required',
            'cardNumber'=>'required',
            'cardMonth'=>'required',
            'cardYear'=>'required',
            'cardSecurityCode'=>'required',
            'campaignId'=>'required',
            'orderId'=>'required',
        ]);
        $el = LP::token($request->token)->first();  
        // if($request->campaignId != $el->campaign_id){
        //     $request->affId = ''; 
        // }
        
        $data = $request->all();
        $data['cardNumber'] = str_replace('-', '',$data['cardNumber']);
        $data['paySource']='CREDITCARD';      
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        $cardno = substr($data['cardNumber'], -4); 
        Log::notice('|| Order request for LP '. $el->name. ', orderid: ' . $data['orderId']. ', campaign id: ' .$data['campaignId']. ', last 4 card digits ' .$cardno);
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Order request for LP '. $el->name. ' failed with error ' . $err);
          return "cURL Error #:" . $err;
        } else {
            $reply = json_decode($response);
            if($reply->result == 'ERROR'){
                Log::error('|| Order request for LP '.$el->name . ' Result: '. json_encode($reply));
                return $response;
            }
            if($reply->result != 'ERROR'){
                $order = Order::where('orderId',$reply->message->orderId)->first();

                $resp = [
                    'shipAddress1'=>$reply->message->shipAddress1,
                    'campaignId'=>$reply->message->campaignId,
                    'shipAddress2'=>$reply->message->shipAddress2,
                    'shipCity'=>$reply->message->shipCity,
                    'shipState'=>$reply->message->shipState,
                    'shipPostalCode'=>$reply->message->shipPostalCode,
                    'totalAmount'=>$reply->message->totalAmount,
                    'campaignName'=>$reply->message->campaignName,
                    'name'=>$reply->message->name,
                    'paySource'=>$reply->message->paySource,
                    'cardType'=>$reply->message->cardType,
                    'cardLast4'=>$reply->message->cardLast4,
                    'cardExpiryDate'=>$reply->message->cardExpiryDate,
                    'cardCVV'=>$request->cardSecurityCode,
                    'cardNumber'=>str_replace('-', '',$request->cardNumber),
                    'basePrice'=>$reply->message->basePrice,
                    'baseShipping'=>$reply->message->baseShipping,
                    'discountPrice'=>$reply->message->discountPrice,
                    'amountPaid'=>$reply->message->amountPaid,
                    'totalDiscount'=>$reply->message->totalDiscount,
                    'sourceId'=>$request->affId,

                ];
                $order->update($resp);
                $order->orderStatus = $reply->message->orderStatus;
                $order->save();
                Log::notice('|| Order request for LP '. $el->name. ' response data: ' . json_encode($reply));
                // add affiliate counter
                if(isset($request->scrubbedId) && $request->scrubbedId != '' || $request->scrubbedId != null ){
                    $request->affId = $request->scrubbedId;
                }
                $aff = Affiliate::where('aff_id', $request->affId)->where('lp_id', $el->id)->first();
                if($aff){
                    $aff->salesCounter = $aff->salesCounter + 1;
                    if($reply->message->campaignId == $el->campaign_id3 && $request->scrubbedId == $aff->aff_id){
                        $aff->scrubCounter = $aff->scrubCounter + 1;
                    }
                    $aff->save();
                }
                return response()->json($response);
            }
        }
    } 
    
    public function newUpsell(Request $request){
        $this->validate($request,[
            'productId'=>'required',
            'orderId'=>'required',
            'token'=>'required',
        ]);
        $el = LP::token($request->token)->first();  
		
        $data = [
            'orderId'=>$request->orderId,
            'productId'=>$request->productId,
			//'productPrice'=> 3000,
        ];
        if($request->productShipPrice){
            $data['productShipPrice'] = $request->productShipPrice;
        }
		if ($request->has('custom_product_price')) {
			$data['productPrice'] = $request->custom_product_price;
		}
		if ($request->custom_product_price) {
			$data['productPrice'] = $request->custom_product_price;
		}
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        Log::notice('|| Order upsell request for LP '. $el->name. ' with data: ' . json_encode($data));
#echo http_build_query($data);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/upsale/import/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Upsell request for LP '. $el->name. ' failed with error ' . $err);
          return "cURL Error #:" . $err;
        } else {
            $reply = json_decode($response);
            if($reply->result == 'ERROR'){
                Log::error('|| Order request for LP '.$el->name . ' Result: '. json_encode($reply));
                return $response;
            }
            $order = Order::where('orderId',$reply->message->orderId)->first();
            $resp = [
              
                'totalAmount'=>$reply->message->totalAmount,
                'basePrice'=>$reply->message->basePrice,
                'baseShipping'=>$reply->message->baseShipping,
                'amountPaid'=>$reply->message->amountPaid,
            ];
            $order->update($resp);
            $order = Order::where('orderId',$reply->message->orderId)->first();
            $order->upsells = $order->upsells +1;
            $order->save();
            Log::notice('|| Upsell request for LP '. $el->name. ' response data: ' . json_encode($reply));
            return response()->json($response);
        }
    }   
    public function rebillOrder(Request $request){
        $this->validate($request,[
            // 'forceMerchantId'=>'required',
            'cardNumber'=>'required',
            'cardMonth'=>'required',
            'cardYear'=>'required',
            'cardSecurityCode'=>'required',
            'campaignId'=>'required',
            'orderId'=>'required',
            'token'=>'required',
        ]);
        $el = LP::token($request->token)->first();  
        $data = $request->all();
        $data['cardNumber'] = str_replace('-', '',$data['cardNumber']);
        $data['paySource']='CREDITCARD';      
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        Log::notice('|| Order rebill request for LP '. $el->name. ' with data: ' . json_encode($data));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Rebill request for LP '. $el->name. ' failed with error ' . $err);
            return redirect()->back()->with('error', 'An error occured: '.$err); 

        } else {
            $reply = json_decode($response);
            if($reply->result == 'ERROR'){
                Log::error('|| Rebill request for LP '.$el->name . ' Result: '. json_encode($reply));
                return redirect()->back()->with('error', 'An error occured: '.json_encode($reply)); 
            }
            $order = Order::where('orderId',$reply->message->orderId)->first();
            $order->orderStatus = $reply->message->orderStatus;
            $order->save();
            Log::notice('|| Rebill request for LP '. $el->name. ' response data: ' . json_encode($reply));
            // return response()->json($reply->message);
            // return response()->json($response);
            return redirect()->back()->with('success', ['Order has been rebilled']); 
        }
    } 
    public function updateCustomerCard(Request $request){
        $this->validate($request,[
            // 'forceMerchantId'=>'required',
            'cardNumber'=>'required',
            'cardMonth'=>'required',
            'cardYear'=>'required',
            'cardSecurityCode'=>'required',
            'campaignId'=>'required',
            'orderId'=>'required',
            'token'=>'required',
        ]);
        $el = LP::token($request->token)->first();  
        $data = $request->all();
        $data['cardNumber'] = str_replace('-', '',$data['cardNumber']);
        $data['paySource']='CREDITCARD';      
        $data['loginId'] = $el->api_user;
        $data['password'] = $el->api_password;
        Log::notice('|| Order rebill request for LP '. $el->name. ' with data: ' . json_encode($data));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($data),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Accept: text/plain"
		  ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Rebill request for LP '. $el->name. ' failed with error ' . $err);
            return redirect()->back()->with('error', 'An error occured: '.$err); 

        } else {
            $reply = json_decode($response);
            if($reply->result == 'ERROR'){
                Log::error('|| Rebill request for LP '.$el->name . ' Result: '. json_encode($reply));
                return redirect()->back()->with('error', 'An error occured: '.json_encode($reply)); 
            }
            $order = Order::where('orderId',$reply->message->orderId)->first();
            $order->orderStatus = $reply->message->orderStatus;
            $order->save();
            Log::notice('|| Rebill request for LP '. $el->name. ' response data: ' . json_encode($reply));
            // return response()->json($reply->message);
            // return response()->json($response);
            return redirect()->back()->with('success', ['Order has been rebilled']); 
        }
    }
    public function togglePixelChange(Request $request){
        $order = Order::where('orderId', $request->orderId)->first();
        $order->pixelFired = 'true';
        $order->save();
        return response('success');
    }    
}
