<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\OrderRetry;
use Log;
use Carbon\Carbon;
class RerunDeclinedCustom extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:rerunDeclinedCustom';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $start = '09:00:00';
        $end   = '17:00:00';
        $now   = Carbon::now();
        $time  = $now->format('H:i:s');

        if ($time >= $start && $time <= $end) {
            $retry = OrderRetry::whereNull('processed')->first();
            Log::notice('|| Order retry custom started');
            $retry = OrderRetryCustom::findOrFail($request->id);
            $payload = [
                'loginId'=>'conceptol_api',
                'password'=>'Qazwsx@12',
                'customerId'=>$retry->customerId,
                'campaignId'=> $retry->campaignId,
                'paySource'=>'ACCTONFILE',
                'cardSecurityCode'=>$retry->cardCVV,
            ];
            $payload['product1_id']=$retry->product1_id;
            if($retry->product2_id){
            $payload['product2_id']=$retry->product2_id;
            }
                     
            $retry->processed = 1;
            $retry->save();
                dd($payload);       
       
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($payload),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,	
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    Log::error('|| Order request failed with error ' . $err);
                } 
                Log::notice('|| Order retry custom complete '.json_encode($response));       

        }
    }
}
