<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\OrderRetry;
use Log;
use Carbon\Carbon;
class RerunDeclined extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:rerunDeclined';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Try and rebill all declined orders';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $start = '09:00:00';
        $end   = '17:00:00';
        $now   = Carbon::now();
        $time  = $now->format('H:i:s');

        if ($time >= $start && $time <= $end) {
            $retry = OrderRetry::whereNull('processed')->first();
            Log::notice('|| Order retry started');
                $order = $retry->order;
                $payload = [
                    'loginId'=>$order->parent->api_user,
                    'password'=>$order->parent->api_password,
                    'customerId'=>$retry->customerId,
                    'campaignId'=> 147,
                    'paySource'=>'ACCTONFILE',
                    'cardSecurityCode'=>$retry->order->cardCVV
                ];
                $upsellCount = 0;
                $cycle = $retry->cycle;
                $prod1;
                $prod2;
                if($retry->product1_id == 170){
                    if($cycle == 2){
                        $prod1 = 643;
                    }else{
                        $prod1 = 658;
                    }
                }
                if($retry->product1_id == 115){
                    if($cycle == 2){
                        $prod1 = 642;
                    }else{
                        $prod1 = 657;
                    }
                }
                if($retry->product2_id != null){
                    if($retry->product2_id == 170){
                        if($cycle == 2){
                            $prod2 = 643;
                        }else{
                            $prod2 = 658;
                        }
                    }
                    if($retry->product2_id == 115){
                        if($cycle == 2){
                            $prod2 = 642;
                        }else{
                            $prod2 = 657;
                        }
                    }
                    $upsellCount++;                    
                }                
                switch($upsellCount){
                    case 0:
                        $payload['product1_id'] = $prod1;
                    break;
                    default:
                        $payload['product1_id'] = $prod1;
                        $payload['product2_id'] = $prod2;
                }           
                // dd($payload);       
                $retry->processed = 1;
                $retry->save();
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($payload),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,	
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    Log::error('|| Order request failed with error ' . $err);
                } 
                Log::notice('|| Order retry complete '.json_encode($response));       

        }
    }
}
