<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Log;
use Carbon\Carbon;
use App\LP;
class ProcessMorphing extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:processMorph';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Rebill all morphing lp orders to different campaign';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        $lp = LP::where('type', '!=','regular')->get();
        foreach($lp as $page){                        
            $orders = $page->orders()->Converted()->where('stage','1')->orderBy('created_at')->get();
            // Log::notice($page->name. ' processing '.count($orders).' rebills');

            foreach($orders as $order){
               
                $date = Carbon::parse($order->created_at)->addDays($page->morph_rebill_days);
                if(!$date->gt(Carbon::now())){
                    $payload = $this->queryKonnOrder($order);
                    if($payload){  
                        $order->stage = 2;
                        $order->save();                      
                        if(isset($payload['product1_id'])&& $payload['product1_id'] != null){
                            Log::notice('|| Page '.$page->name.' Sending New Order to Konnektive with payload: ' . json_encode($payload));
                            $this->sendKonnOrder($payload);                    
                        }else{
                            Log::notice('|| Page '.$page->name.' cannot send order payload: ' . json_encode($payload));
                        }
                    }
                }
                // else{
                //     Log::notice('|| Order not due. Skipping '.$order->orderId);
                // }
            }                       
        }
    }
    private function queryKonnOrder($order){
        $page = $order->parent;
        $date = Carbon::parse($order->created_at)->addDays($page->morph_rebill_days);
        $payload = [
            'loginId'=>$page->api_user,
            'password'=>$page->api_password,
            'orderId'=>$order->orderId,
        ];
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/query/?'.http_build_query($payload),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,	
        ));
        $response = curl_exec($curl);
        curl_close($curl);       
        // Log::notice($response);      
        $response = json_decode($response);
        if($response->result === 'ERROR'){                    
            Log::notice('|| Konnektive error: '.$response->result. ', '. $response->message);
            return;
        } else{                
            // Log::notice('|| Konnektive reply result: '.$response->result);
        }    
        $response = $response->message->data[0];
        $stage1= [$page->campaign_id,$page->campaign_id2,$page->campaign_id3,$page->campaign_id4];
        $stage2= [$page->morph_campaign_id,$page->morph_campaign_id2,$page->morph_campaign_id3,$page->morph_campaign_id4];                        
        if($response->orderStatus && $response->orderStatus == 'COMPLETE'){
            foreach($stage1 as $key=>$value){                        
                if($value == $response->campaignId){
                    // Log::notice($value.', '.$response->campaignId.', key:'.$key );     
                    $newCampaign = $stage2[$key];
                    Log::notice('|| Order '.$order->orderId.' qualified to rebill. Campaign id '.$response->campaignId. ' morphs to '.$newCampaign);
                    $payload = [
                        'loginId'=>$page->api_user,
                        'password'=>$page->api_password,
                        'customerId'=>$response->customerId,
                        'campaignId'=> $newCampaign,
                        'paySource'=>'ACCTONFILE',
                        'cardSecurityCode'=>$order->cardCVV,                
                    ];
                    $prodids = [];                                        
                    // Log::notice(json_encode($response->items));
                    // determine the product id to use 
                    $i=1;
                    $id = null;
                    // Log::notice('|| Konn Order got ids '.json_encode($response->items));  
                    foreach($response->items as $key=>$item){
                        // Log::notice(json_encode($item));
                        // check step 1 all cases
                        if($item->productId == $page->product1_id){
                            $id = $page->product1_id_morph;                        
                        }
                        if($item->productId == $page->product1_id_c2){
                            $id = $page->product1_id_c2_morph;                        
                        }
                        if($item->productId == $page->product1_id_c3){
                            $id = $page->product1_id_c3_morph;                        
                        }
                        if($item->productId == $page->product1_id_c4){
                            $id = $page->product1_id_c4_morph;                        
                        }
                        if($item->productId == $page->product1_7_id){
                            $id = $page->product1_7_id_morph;                        
                        }
                        if($item->productId == $page->product1_5_id){
                            $id = $page->product1_5_id_morph;                        
                        }
                        if($item->productId == $page->product1_3_id){
                            $id = $page->product1_3_id_morph;                        
                        }
                        if($item->productId == $page->product1_1_id){
                            $id = $page->product1_1_id_morph;                        
                        }
                        // c2
                        if($item->productId == $page->product1_7_id_c2){
                            $id = $page->product1_7_id_c2_morph;                        
                        }
                        if($item->productId == $page->product1_5_id_c2){
                            $id = $page->product1_5_id_c2_morph;                        
                        }
                        if($item->productId == $page->product1_3_id_c2){
                            $id = $page->product1_3_id_c2_morph;                        
                        }
                        if($item->productId == $page->product1_1_id_c2){
                            $id = $page->product1_1_id_c2_morph;                        
                        }
                        // c3
                        if($item->productId == $page->product1_7_id_c3){
                            $id = $page->product1_7_id_c3_morph;                        
                        }
                        if($item->productId == $page->product1_5_id_c3){
                            $id = $page->product1_5_id_c3_morph;                        
                        }
                        if($item->productId == $page->product1_3_id_c3){
                            $id = $page->product1_3_id_c3_morph;                        
                        }
                        if($item->productId == $page->product1_1_id_c3){
                            $id = $page->product1_1_id_c3_morph;                        
                        }
                        // c4
                        if($item->productId == $page->product1_7_id_c4){
                            $id = $page->product1_7_id_c4_morph;                        
                        }
                        if($item->productId == $page->product1_5_id_c4){
                            $id = $page->product1_5_id_c4_morph;                        
                        }
                        if($item->productId == $page->product1_3_id_c4){
                            $id = $page->product1_3_id_c4_morph;                        
                        }
                        if($item->productId == $page->product1_1_id_c4){
                            $id = $page->product1_1_id_c4_morph;                        
                        }
                        // check step 2 all cases
                        if($item->productId == $page->product2_id){
                            $id = $page->product2_id_morph;                            
                        }
                        if($item->productId == $page->product2_id_c2){
                            $id = $page->product2_id_c2_morph;                            
                        }
                        if($item->productId == $page->product2_id_c3){
                            $id = $page->product2_id_c3_morph;                            
                        }
                        if($item->productId == $page->product2_id_c4){
                            $id = $page->product2_id_c4_morph;                            
                        }

                        if($item->productId == $page->product2_1_id_c2){
                            $id = $page->product2_1_id_c2_morph;                            
                        }
                        if($item->productId == $page->product2_2_id_c2){
                            $id = $page->product2_2_id_c2_morph;                            
                        }

                        if($item->productId == $page->product2_1_id_c3){
                            $id = $page->product2_1_id_c3_morph;                            
                        }
                        if($item->productId == $page->product2_2_id_c3){
                            $id = $page->product2_2_id_c3_morph;                            
                        }

                        if($item->productId == $page->product2_1_id_c4){
                            $id = $page->product2_1_id_c4_morph;                            
                        }
                        if($item->productId == $page->product2_2_id_c4){
                            $id = $page->product2_2_id_c4_morph;                            
                        }

                           // check step 3 all cases
                           if($item->productId == $page->product3_id){
                            $id = $page->product3_id_morph;                            
                        }
                        if($item->productId == $page->product3_id_c2){
                            $id = $page->product3_id_c2_morph;                            
                        }
                        if($item->productId == $page->product3_id_c3){
                            $id = $page->product3_id_c3_morph;                            
                        }
                        if($item->productId == $page->product3_id_c4){
                            $id = $page->product3_id_c4_morph;                            
                        }

                        if($item->productId == $page->product3_1_id_c2){
                            $id = $page->product3_1_id_c2_morph;                            
                        }
                        if($item->productId == $page->product3_2_id_c2){
                            $id = $page->product3_2_id_c2_morph;                            
                        }

                        if($item->productId == $page->product3_1_id_c3){
                            $id = $page->product3_1_id_c3_morph;                            
                        }
                        if($item->productId == $page->product3_2_id_c3){
                            $id = $page->product3_2_id_c3_morph;                            
                        }

                        if($item->productId == $page->product3_1_id_c4){
                            $id = $page->product3_1_id_c4_morph;                            
                        }
                        if($item->productId == $page->product3_2_id_c4){
                            $id = $page->product3_2_id_c4_morph;                            
                        }


                           // check step 4 all cases
                           if($item->productId == $page->product4_id){
                            $id = $page->product4_id_morph;                            
                        }
                        if($item->productId == $page->product4_id_c2){
                            $id = $page->product4_id_c2_morph;                            
                        }
                        if($item->productId == $page->product4_id_c3){
                            $id = $page->product4_id_c3_morph;                            
                        }
                        if($item->productId == $page->product4_id_c4){
                            $id = $page->product4_id_c4_morph;                            
                        }

                        if($item->productId == $page->product4_1_id_c2){
                            $id = $page->product4_1_id_c2_morph;                            
                        }
                        if($item->productId == $page->product4_2_id_c2){
                            $id = $page->product4_2_id_c2_morph;                            
                        }

                        if($item->productId == $page->product4_1_id_c3){
                            $id = $page->product4_1_id_c3_morph;                            
                        }
                        if($item->productId == $page->product4_2_id_c3){
                            $id = $page->product4_2_id_c3_morph;                            
                        }

                        if($item->productId == $page->product4_1_id_c4){
                            $id = $page->product4_1_id_c4_morph;                            
                        }
                        if($item->productId == $page->product4_2_id_c4){
                            $id = $page->product4_2_id_c4_morph;                            
                        }
                        
                        $payload['product'.$i.'_id']=$id;
                        
                        $i++;
                        Log::notice('|| Item productId '.$item->productId.' morphs to '.$id);  

                    }
                    // foreach($response->items as $key=>$item){
                    //     $i++;
                    // }
                    return $payload;
                }
            }
        }
        // else{
        //     Log::notice('|| Order not due. Skipping '.$order->orderId);
        // }
    }
    private function sendKonnOrder($payload){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.konnektive.com/order/import/?'.http_build_query($payload),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,	
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            Log::error('|| Order request failed with error ' . $err);
        } 
        Log::notice('|| Order retry complete! response: '.json_encode($response) );       
    }
}
